@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.appplatform.kotlin.inputs

import com.pulumi.azurenative.appplatform.inputs.TCPSocketActionArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * TCPSocketAction describes an action based on opening a socket
 * @property type The type of the action to take to perform the health check.
 * Expected value is 'TCPSocketAction'.
 */
public data class TCPSocketActionArgs(
    public val type: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.appplatform.inputs.TCPSocketActionArgs> {
    override fun toJava(): com.pulumi.azurenative.appplatform.inputs.TCPSocketActionArgs =
        com.pulumi.azurenative.appplatform.inputs.TCPSocketActionArgs.builder()
            .type(type.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [TCPSocketActionArgs].
 */
@PulumiTagMarker
public class TCPSocketActionArgsBuilder internal constructor() {
    private var type: Output<String>? = null

    /**
     * @param value The type of the action to take to perform the health check.
     * Expected value is 'TCPSocketAction'.
     */
    @JvmName("kdxshnkiwcwhecas")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value The type of the action to take to perform the health check.
     * Expected value is 'TCPSocketAction'.
     */
    @JvmName("qigodsaqjcqrsdrf")
    public suspend fun type(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): TCPSocketActionArgs = TCPSocketActionArgs(
        type = type ?: throw PulumiNullFieldException("type"),
    )
}
