@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.appplatform.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Collection of instances belong to the API portal
 * @property name Name of the API portal instance
 * @property status Status of the API portal instance
 */
public data class ApiPortalInstanceResponse(
    public val name: String,
    public val status: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.appplatform.outputs.ApiPortalInstanceResponse):
            ApiPortalInstanceResponse = ApiPortalInstanceResponse(
            name = javaType.name(),
            status = javaType.status(),
        )
    }
}
