@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.appplatform.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Resource request payload of Build Resource.
 * @property cpu Optional Cpu allocated to the build resource. 1 core can be represented by 1 or 1000m.
 * The default value is 1, this should not exceed build service agent pool cpu size.
 * @property memory Optional Memory allocated to the build resource. 1 GB can be represented by 1Gi or 1024Mi.
 * The default value is 2Gi, this should not exceed build service agent pool memory size.
 */
public data class BuildResourceRequestsResponse(
    public val cpu: String? = null,
    public val memory: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.appplatform.outputs.BuildResourceRequestsResponse):
            BuildResourceRequestsResponse = BuildResourceRequestsResponse(
            cpu = javaType.cpu().map({ args0 -> args0 }).orElse(null),
            memory = javaType.memory().map({ args0 -> args0 }).orElse(null),
        )
    }
}
