@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.appplatform.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Application Configuration Service properties payload
 * @property generation The generation of the Application Configuration Service.
 * @property instances Collection of instances belong to Application Configuration Service.
 * @property provisioningState State of the Application Configuration Service.
 * @property resourceRequests The requested resource quantity for required CPU and Memory.
 * @property settings The settings of Application Configuration Service.
 */
public data class ConfigurationServicePropertiesResponse(
    public val generation: String? = null,
    public val instances: List<ConfigurationServiceInstanceResponse>,
    public val provisioningState: String,
    public val resourceRequests: ConfigurationServiceResourceRequestsResponse,
    public val settings: ConfigurationServiceSettingsResponse? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.appplatform.outputs.ConfigurationServicePropertiesResponse):
            ConfigurationServicePropertiesResponse = ConfigurationServicePropertiesResponse(
            generation = javaType.generation().map({ args0 -> args0 }).orElse(null),
            instances = javaType.instances().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.appplatform.kotlin.outputs.ConfigurationServiceInstanceResponse.Companion.toKotlin(args0)
                })
            }),
            provisioningState = javaType.provisioningState(),
            resourceRequests = javaType.resourceRequests().let({ args0 ->
                com.pulumi.azurenative.appplatform.kotlin.outputs.ConfigurationServiceResourceRequestsResponse.Companion.toKotlin(args0)
            }),
            settings = javaType.settings().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.appplatform.kotlin.outputs.ConfigurationServiceSettingsResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
