@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.appplatform.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Custom persistent disk resource payload.
 * @property customPersistentDiskProperties Properties of the custom persistent disk resource payload.
 * @property storageId The resource id of Azure Spring Apps Storage resource.
 */
public data class CustomPersistentDiskResourceResponse(
    public val customPersistentDiskProperties: AzureFileVolumeResponse? = null,
    public val storageId: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.appplatform.outputs.CustomPersistentDiskResourceResponse):
            CustomPersistentDiskResourceResponse = CustomPersistentDiskResourceResponse(
            customPersistentDiskProperties = javaType.customPersistentDiskProperties().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.appplatform.kotlin.outputs.AzureFileVolumeResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            storageId = javaType.storageId(),
        )
    }
}
