@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.appplatform.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property instances Collection of instances belong to Dev Tool Portal.
 * @property name
 * @property resourceRequests The requested resource quantity for required CPU and Memory.
 */
public data class DevToolPortalComponentResponse(
    public val instances: List<DevToolPortalInstanceResponse>,
    public val name: String,
    public val resourceRequests: DevToolPortalResourceRequestsResponse,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.appplatform.outputs.DevToolPortalComponentResponse):
            DevToolPortalComponentResponse = DevToolPortalComponentResponse(
            instances = javaType.instances().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.appplatform.kotlin.outputs.DevToolPortalInstanceResponse.Companion.toKotlin(args0)
                })
            }),
            name = javaType.name(),
            resourceRequests = javaType.resourceRequests().let({ args0 ->
                com.pulumi.azurenative.appplatform.kotlin.outputs.DevToolPortalResourceRequestsResponse.Companion.toKotlin(args0)
            }),
        )
    }
}
