@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.appplatform.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * ExecAction describes a "run in container" action.
 * @property command Command is the command line to execute inside the container, the working directory for the command is root ('/') in the container's filesystem. The command is not run inside a shell, so traditional shell instructions ('|', etc) won't work. To use a shell, you need to explicitly call out to that shell. Exit status of 0 is treated as live/healthy and non-zero is unhealthy.
 * @property type The type of the action to take to perform the health check.
 * Expected value is 'ExecAction'.
 */
public data class ExecActionResponse(
    public val command: List<String>? = null,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.appplatform.outputs.ExecActionResponse):
            ExecActionResponse = ExecActionResponse(
            command = javaType.command().map({ args0 -> args0 }),
            type = javaType.type(),
        )
    }
}
