@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.appplatform.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * API metadata property for Spring Cloud Gateway
 * @property description Detailed description of the APIs available on the Gateway instance (default: `Generated OpenAPI 3 document that describes the API routes configured.`)
 * @property documentation Location of additional documentation for the APIs available on the Gateway instance
 * @property serverUrl Base URL that API consumers will use to access APIs on the Gateway instance.
 * @property title Title describing the context of the APIs available on the Gateway instance (default: `Spring Cloud Gateway for K8S`)
 * @property version Version of APIs available on this Gateway instance (default: `unspecified`).
 */
public data class GatewayApiMetadataPropertiesResponse(
    public val description: String? = null,
    public val documentation: String? = null,
    public val serverUrl: String? = null,
    public val title: String? = null,
    public val version: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.appplatform.outputs.GatewayApiMetadataPropertiesResponse):
            GatewayApiMetadataPropertiesResponse = GatewayApiMetadataPropertiesResponse(
            description = javaType.description().map({ args0 -> args0 }).orElse(null),
            documentation = javaType.documentation().map({ args0 -> args0 }).orElse(null),
            serverUrl = javaType.serverUrl().map({ args0 -> args0 }).orElse(null),
            title = javaType.title().map({ args0 -> args0 }).orElse(null),
            version = javaType.version().map({ args0 -> args0 }).orElse(null),
        )
    }
}
