@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.appplatform.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Cross-Origin Resource Sharing property
 * @property allowCredentials Whether user credentials are supported on cross-site requests. Valid values: `true`, `false`.
 * @property allowedHeaders Allowed headers in cross-site requests. The special value `*` allows actual requests to send any header.
 * @property allowedMethods Allowed HTTP methods on cross-site requests. The special value `*` allows all methods. If not set, `GET` and `HEAD` are allowed by default.
 * @property allowedOriginPatterns Allowed origin patterns to make cross-site requests.
 * @property allowedOrigins Allowed origins to make cross-site requests. The special value `*` allows all domains.
 * @property exposedHeaders HTTP response headers to expose for cross-site requests.
 * @property maxAge How long, in seconds, the response from a pre-flight request can be cached by clients.
 */
public data class GatewayCorsPropertiesResponse(
    public val allowCredentials: Boolean? = null,
    public val allowedHeaders: List<String>? = null,
    public val allowedMethods: List<String>? = null,
    public val allowedOriginPatterns: List<String>? = null,
    public val allowedOrigins: List<String>? = null,
    public val exposedHeaders: List<String>? = null,
    public val maxAge: Int? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.appplatform.outputs.GatewayCorsPropertiesResponse):
            GatewayCorsPropertiesResponse = GatewayCorsPropertiesResponse(
            allowCredentials = javaType.allowCredentials().map({ args0 -> args0 }).orElse(null),
            allowedHeaders = javaType.allowedHeaders().map({ args0 -> args0 }),
            allowedMethods = javaType.allowedMethods().map({ args0 -> args0 }),
            allowedOriginPatterns = javaType.allowedOriginPatterns().map({ args0 -> args0 }),
            allowedOrigins = javaType.allowedOrigins().map({ args0 -> args0 }),
            exposedHeaders = javaType.exposedHeaders().map({ args0 -> args0 }),
            maxAge = javaType.maxAge().map({ args0 -> args0 }).orElse(null),
        )
    }
}
