@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.appplatform.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.Suppress

/**
 * Remote debugging config.
 * @property enabled Indicate if remote debugging is enabled
 * @property port Application debugging port
 */
public data class GetDeploymentRemoteDebuggingConfigResult(
    public val enabled: Boolean? = null,
    public val port: Int? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.appplatform.outputs.GetDeploymentRemoteDebuggingConfigResult):
            GetDeploymentRemoteDebuggingConfigResult = GetDeploymentRemoteDebuggingConfigResult(
            enabled = javaType.enabled().map({ args0 -> args0 }).orElse(null),
            port = javaType.port().map({ args0 -> args0 }).orElse(null),
        )
    }
}
