@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.appplatform.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * HTTPGetAction describes an action based on HTTP Get requests.
 * @property path Path to access on the HTTP server.
 * @property scheme Scheme to use for connecting to the host. Defaults to HTTP.
 * Possible enum values:
 *  - `"HTTP"` means that the scheme used will be http://
 *  - `"HTTPS"` means that the scheme used will be https://
 * @property type The type of the action to take to perform the health check.
 * Expected value is 'HTTPGetAction'.
 */
public data class HTTPGetActionResponse(
    public val path: String? = null,
    public val scheme: String? = null,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.appplatform.outputs.HTTPGetActionResponse):
            HTTPGetActionResponse = HTTPGetActionResponse(
            path = javaType.path().map({ args0 -> args0 }).orElse(null),
            scheme = javaType.scheme().map({ args0 -> args0 }).orElse(null),
            type = javaType.type(),
        )
    }
}
