@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.appplatform.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 * Test keys payload
 * @property enabled Indicates whether the test endpoint feature enabled or not
 * @property primaryKey Primary key
 * @property primaryTestEndpoint Primary test endpoint
 * @property secondaryKey Secondary key
 * @property secondaryTestEndpoint Secondary test endpoint
 */
public data class ListServiceTestKeysResult(
    public val enabled: Boolean? = null,
    public val primaryKey: String? = null,
    public val primaryTestEndpoint: String? = null,
    public val secondaryKey: String? = null,
    public val secondaryTestEndpoint: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.appplatform.outputs.ListServiceTestKeysResult):
            ListServiceTestKeysResult = ListServiceTestKeysResult(
            enabled = javaType.enabled().map({ args0 -> args0 }).orElse(null),
            primaryKey = javaType.primaryKey().map({ args0 -> args0 }).orElse(null),
            primaryTestEndpoint = javaType.primaryTestEndpoint().map({ args0 -> args0 }).orElse(null),
            secondaryKey = javaType.secondaryKey().map({ args0 -> args0 }).orElse(null),
            secondaryTestEndpoint = javaType.secondaryTestEndpoint().map({ args0 -> args0 }).orElse(null),
        )
    }
}
