@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.appplatform.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Service Registry properties payload
 * @property instances Collection of instances belong to Service Registry.
 * @property provisioningState State of the Service Registry.
 * @property resourceRequests The requested resource quantity for required CPU and Memory.
 */
public data class ServiceRegistryPropertiesResponse(
    public val instances: List<ServiceRegistryInstanceResponse>,
    public val provisioningState: String,
    public val resourceRequests: ServiceRegistryResourceRequestsResponse,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.appplatform.outputs.ServiceRegistryPropertiesResponse):
            ServiceRegistryPropertiesResponse = ServiceRegistryPropertiesResponse(
            instances = javaType.instances().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.appplatform.kotlin.outputs.ServiceRegistryInstanceResponse.Companion.toKotlin(args0)
                })
            }),
            provisioningState = javaType.provisioningState(),
            resourceRequests = javaType.resourceRequests().let({ args0 ->
                com.pulumi.azurenative.appplatform.kotlin.outputs.ServiceRegistryResourceRequestsResponse.Companion.toKotlin(args0)
            }),
        )
    }
}
