@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.appplatform.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 * Temporary disk payload
 * @property mountPath Mount path of the temporary disk
 * @property sizeInGB Size of the temporary disk in GB
 */
public data class TemporaryDiskResponse(
    public val mountPath: String? = null,
    public val sizeInGB: Int? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.appplatform.outputs.TemporaryDiskResponse):
            TemporaryDiskResponse = TemporaryDiskResponse(
            mountPath = javaType.mountPath().map({ args0 -> args0 }).orElse(null),
            sizeInGB = javaType.sizeInGB().map({ args0 -> args0 }).orElse(null),
        )
    }
}
