@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.attestation.kotlin.inputs

import com.pulumi.azurenative.attestation.inputs.JSONWebKeyArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property alg The "alg" (algorithm) parameter identifies the algorithm intended for
 * use with the key.  The values used should either be registered in the
 * IANA "JSON Web Signature and Encryption Algorithms" registry
 * established by [JWA] or be a value that contains a Collision-
 * Resistant Name.
 * @property crv The "crv" (curve) parameter identifies the curve type
 * @property d RSA private exponent or ECC private key
 * @property dp RSA Private Key Parameter
 * @property dq RSA Private Key Parameter
 * @property e RSA public exponent, in Base64
 * @property k Symmetric key
 * @property kid The "kid" (key ID) parameter is used to match a specific key.  This
 * is used, for instance, to choose among a set of keys within a JWK Set
 * during key rollover.  The structure of the "kid" value is
 * unspecified.  When "kid" values are used within a JWK Set, different
 * keys within the JWK Set SHOULD use distinct "kid" values.  (One
 * example in which different keys might use the same "kid" value is if
 * they have different "kty" (key type) values but are considered to be
 * equivalent alternatives by the application using them.)  The "kid"
 * value is a case-sensitive string.
 * @property kty The "kty" (key type) parameter identifies the cryptographic algorithm
 * family used with the key, such as "RSA" or "EC". "kty" values should
 * either be registered in the IANA "JSON Web Key Types" registry
 * established by [JWA] or be a value that contains a Collision-
 * Resistant Name.  The "kty" value is a case-sensitive string.
 * @property n RSA modulus, in Base64
 * @property p RSA secret prime
 * @property q RSA secret prime, with p < q
 * @property qi RSA Private Key Parameter
 * @property use Use ("public key use") identifies the intended use of
 * the public key. The "use" parameter is employed to indicate whether
 * a public key is used for encrypting data or verifying the signature
 * on data. Values are commonly "sig" (signature) or "enc" (encryption).
 * @property x X coordinate for the Elliptic Curve point
 * @property x5c The "x5c" (X.509 certificate chain) parameter contains a chain of one
 * or more PKIX certificates [RFC5280].  The certificate chain is
 * represented as a JSON array of certificate value strings.  Each
 * string in the array is a base64-encoded (Section 4 of [RFC4648] --
 * not base64url-encoded) DER [ITU&#46;X690&#46;1994] PKIX certificate value.
 * The PKIX certificate containing the key value MUST be the first
 * certificate.
 * @property y Y coordinate for the Elliptic Curve point
 */
public data class JSONWebKeyArgs(
    public val alg: Output<String>? = null,
    public val crv: Output<String>? = null,
    public val d: Output<String>? = null,
    public val dp: Output<String>? = null,
    public val dq: Output<String>? = null,
    public val e: Output<String>? = null,
    public val k: Output<String>? = null,
    public val kid: Output<String>? = null,
    public val kty: Output<String>,
    public val n: Output<String>? = null,
    public val p: Output<String>? = null,
    public val q: Output<String>? = null,
    public val qi: Output<String>? = null,
    public val use: Output<String>? = null,
    public val x: Output<String>? = null,
    public val x5c: Output<List<String>>? = null,
    public val y: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.attestation.inputs.JSONWebKeyArgs> {
    override fun toJava(): com.pulumi.azurenative.attestation.inputs.JSONWebKeyArgs =
        com.pulumi.azurenative.attestation.inputs.JSONWebKeyArgs.builder()
            .alg(alg?.applyValue({ args0 -> args0 }))
            .crv(crv?.applyValue({ args0 -> args0 }))
            .d(d?.applyValue({ args0 -> args0 }))
            .dp(dp?.applyValue({ args0 -> args0 }))
            .dq(dq?.applyValue({ args0 -> args0 }))
            .e(e?.applyValue({ args0 -> args0 }))
            .k(k?.applyValue({ args0 -> args0 }))
            .kid(kid?.applyValue({ args0 -> args0 }))
            .kty(kty.applyValue({ args0 -> args0 }))
            .n(n?.applyValue({ args0 -> args0 }))
            .p(p?.applyValue({ args0 -> args0 }))
            .q(q?.applyValue({ args0 -> args0 }))
            .qi(qi?.applyValue({ args0 -> args0 }))
            .use(use?.applyValue({ args0 -> args0 }))
            .x(x?.applyValue({ args0 -> args0 }))
            .x5c(x5c?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .y(y?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [JSONWebKeyArgs].
 */
@PulumiTagMarker
public class JSONWebKeyArgsBuilder internal constructor() {
    private var alg: Output<String>? = null

    private var crv: Output<String>? = null

    private var d: Output<String>? = null

    private var dp: Output<String>? = null

    private var dq: Output<String>? = null

    private var e: Output<String>? = null

    private var k: Output<String>? = null

    private var kid: Output<String>? = null

    private var kty: Output<String>? = null

    private var n: Output<String>? = null

    private var p: Output<String>? = null

    private var q: Output<String>? = null

    private var qi: Output<String>? = null

    private var use: Output<String>? = null

    private var x: Output<String>? = null

    private var x5c: Output<List<String>>? = null

    private var y: Output<String>? = null

    /**
     * @param value The "alg" (algorithm) parameter identifies the algorithm intended for
     * use with the key.  The values used should either be registered in the
     * IANA "JSON Web Signature and Encryption Algorithms" registry
     * established by [JWA] or be a value that contains a Collision-
     * Resistant Name.
     */
    @JvmName("koduyjhsrrkvdfjm")
    public suspend fun alg(`value`: Output<String>) {
        this.alg = value
    }

    /**
     * @param value The "crv" (curve) parameter identifies the curve type
     */
    @JvmName("yvdocresknohiaeu")
    public suspend fun crv(`value`: Output<String>) {
        this.crv = value
    }

    /**
     * @param value RSA private exponent or ECC private key
     */
    @JvmName("lvfqbuvgcfyugpbl")
    public suspend fun d(`value`: Output<String>) {
        this.d = value
    }

    /**
     * @param value RSA Private Key Parameter
     */
    @JvmName("kuwacbodycdkuwti")
    public suspend fun dp(`value`: Output<String>) {
        this.dp = value
    }

    /**
     * @param value RSA Private Key Parameter
     */
    @JvmName("oyknwkvbofbbtphs")
    public suspend fun dq(`value`: Output<String>) {
        this.dq = value
    }

    /**
     * @param value RSA public exponent, in Base64
     */
    @JvmName("xrsdqushibowrbdk")
    public suspend fun e(`value`: Output<String>) {
        this.e = value
    }

    /**
     * @param value Symmetric key
     */
    @JvmName("xkrhpubhgejbbnfw")
    public suspend fun k(`value`: Output<String>) {
        this.k = value
    }

    /**
     * @param value The "kid" (key ID) parameter is used to match a specific key.  This
     * is used, for instance, to choose among a set of keys within a JWK Set
     * during key rollover.  The structure of the "kid" value is
     * unspecified.  When "kid" values are used within a JWK Set, different
     * keys within the JWK Set SHOULD use distinct "kid" values.  (One
     * example in which different keys might use the same "kid" value is if
     * they have different "kty" (key type) values but are considered to be
     * equivalent alternatives by the application using them.)  The "kid"
     * value is a case-sensitive string.
     */
    @JvmName("bhnxvlcikwfkjhcv")
    public suspend fun kid(`value`: Output<String>) {
        this.kid = value
    }

    /**
     * @param value The "kty" (key type) parameter identifies the cryptographic algorithm
     * family used with the key, such as "RSA" or "EC". "kty" values should
     * either be registered in the IANA "JSON Web Key Types" registry
     * established by [JWA] or be a value that contains a Collision-
     * Resistant Name.  The "kty" value is a case-sensitive string.
     */
    @JvmName("xqgksbbbejiobmdk")
    public suspend fun kty(`value`: Output<String>) {
        this.kty = value
    }

    /**
     * @param value RSA modulus, in Base64
     */
    @JvmName("kqaijsjpsvfvhknf")
    public suspend fun n(`value`: Output<String>) {
        this.n = value
    }

    /**
     * @param value RSA secret prime
     */
    @JvmName("ylvmhagmpilhdapu")
    public suspend fun p(`value`: Output<String>) {
        this.p = value
    }

    /**
     * @param value RSA secret prime, with p < q
     */
    @JvmName("hiwrugnobkhwqwex")
    public suspend fun q(`value`: Output<String>) {
        this.q = value
    }

    /**
     * @param value RSA Private Key Parameter
     */
    @JvmName("pmgjlneyuxtojvsu")
    public suspend fun qi(`value`: Output<String>) {
        this.qi = value
    }

    /**
     * @param value Use ("public key use") identifies the intended use of
     * the public key. The "use" parameter is employed to indicate whether
     * a public key is used for encrypting data or verifying the signature
     * on data. Values are commonly "sig" (signature) or "enc" (encryption).
     */
    @JvmName("catwqlfbtacrysmt")
    public suspend fun use(`value`: Output<String>) {
        this.use = value
    }

    /**
     * @param value X coordinate for the Elliptic Curve point
     */
    @JvmName("bebpdleqwpjcgmfa")
    public suspend fun x(`value`: Output<String>) {
        this.x = value
    }

    /**
     * @param value The "x5c" (X.509 certificate chain) parameter contains a chain of one
     * or more PKIX certificates [RFC5280].  The certificate chain is
     * represented as a JSON array of certificate value strings.  Each
     * string in the array is a base64-encoded (Section 4 of [RFC4648] --
     * not base64url-encoded) DER [ITU&#46;X690&#46;1994] PKIX certificate value.
     * The PKIX certificate containing the key value MUST be the first
     * certificate.
     */
    @JvmName("ynhsfvjbtbvokwxr")
    public suspend fun x5c(`value`: Output<List<String>>) {
        this.x5c = value
    }

    @JvmName("jhqbysqquudonreh")
    public suspend fun x5c(vararg values: Output<String>) {
        this.x5c = Output.all(values.asList())
    }

    /**
     * @param values The "x5c" (X.509 certificate chain) parameter contains a chain of one
     * or more PKIX certificates [RFC5280].  The certificate chain is
     * represented as a JSON array of certificate value strings.  Each
     * string in the array is a base64-encoded (Section 4 of [RFC4648] --
     * not base64url-encoded) DER [ITU&#46;X690&#46;1994] PKIX certificate value.
     * The PKIX certificate containing the key value MUST be the first
     * certificate.
     */
    @JvmName("lqwbabgkjacokvbj")
    public suspend fun x5c(values: List<Output<String>>) {
        this.x5c = Output.all(values)
    }

    /**
     * @param value Y coordinate for the Elliptic Curve point
     */
    @JvmName("eecjbhdodfovouuw")
    public suspend fun y(`value`: Output<String>) {
        this.y = value
    }

    /**
     * @param value The "alg" (algorithm) parameter identifies the algorithm intended for
     * use with the key.  The values used should either be registered in the
     * IANA "JSON Web Signature and Encryption Algorithms" registry
     * established by [JWA] or be a value that contains a Collision-
     * Resistant Name.
     */
    @JvmName("lvrskpligxxdntqs")
    public suspend fun alg(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.alg = mapped
    }

    /**
     * @param value The "crv" (curve) parameter identifies the curve type
     */
    @JvmName("udkbcpfaxnfsbnbv")
    public suspend fun crv(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.crv = mapped
    }

    /**
     * @param value RSA private exponent or ECC private key
     */
    @JvmName("evcuplxckulyvxkj")
    public suspend fun d(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.d = mapped
    }

    /**
     * @param value RSA Private Key Parameter
     */
    @JvmName("wylgqnyannrjwinp")
    public suspend fun dp(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dp = mapped
    }

    /**
     * @param value RSA Private Key Parameter
     */
    @JvmName("algquyihlhgedwqm")
    public suspend fun dq(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dq = mapped
    }

    /**
     * @param value RSA public exponent, in Base64
     */
    @JvmName("kokgufpxtvtyrqtk")
    public suspend fun e(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.e = mapped
    }

    /**
     * @param value Symmetric key
     */
    @JvmName("wtmtgljymoyclavc")
    public suspend fun k(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.k = mapped
    }

    /**
     * @param value The "kid" (key ID) parameter is used to match a specific key.  This
     * is used, for instance, to choose among a set of keys within a JWK Set
     * during key rollover.  The structure of the "kid" value is
     * unspecified.  When "kid" values are used within a JWK Set, different
     * keys within the JWK Set SHOULD use distinct "kid" values.  (One
     * example in which different keys might use the same "kid" value is if
     * they have different "kty" (key type) values but are considered to be
     * equivalent alternatives by the application using them.)  The "kid"
     * value is a case-sensitive string.
     */
    @JvmName("qluosfblytdmabrk")
    public suspend fun kid(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kid = mapped
    }

    /**
     * @param value The "kty" (key type) parameter identifies the cryptographic algorithm
     * family used with the key, such as "RSA" or "EC". "kty" values should
     * either be registered in the IANA "JSON Web Key Types" registry
     * established by [JWA] or be a value that contains a Collision-
     * Resistant Name.  The "kty" value is a case-sensitive string.
     */
    @JvmName("ikckpkvgrslvwanc")
    public suspend fun kty(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.kty = mapped
    }

    /**
     * @param value RSA modulus, in Base64
     */
    @JvmName("kxcgowrijhusyhpx")
    public suspend fun n(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.n = mapped
    }

    /**
     * @param value RSA secret prime
     */
    @JvmName("njnjlvfnjyafhdib")
    public suspend fun p(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.p = mapped
    }

    /**
     * @param value RSA secret prime, with p < q
     */
    @JvmName("dygqbootwtllsqqk")
    public suspend fun q(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.q = mapped
    }

    /**
     * @param value RSA Private Key Parameter
     */
    @JvmName("vdcyomdlhdxyiwdj")
    public suspend fun qi(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.qi = mapped
    }

    /**
     * @param value Use ("public key use") identifies the intended use of
     * the public key. The "use" parameter is employed to indicate whether
     * a public key is used for encrypting data or verifying the signature
     * on data. Values are commonly "sig" (signature) or "enc" (encryption).
     */
    @JvmName("myfbvydrsqoqoxxn")
    public suspend fun use(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.use = mapped
    }

    /**
     * @param value X coordinate for the Elliptic Curve point
     */
    @JvmName("lxrtpfrdblgmmqbi")
    public suspend fun x(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.x = mapped
    }

    /**
     * @param value The "x5c" (X.509 certificate chain) parameter contains a chain of one
     * or more PKIX certificates [RFC5280].  The certificate chain is
     * represented as a JSON array of certificate value strings.  Each
     * string in the array is a base64-encoded (Section 4 of [RFC4648] --
     * not base64url-encoded) DER [ITU&#46;X690&#46;1994] PKIX certificate value.
     * The PKIX certificate containing the key value MUST be the first
     * certificate.
     */
    @JvmName("phsqjcqhikdjfwxi")
    public suspend fun x5c(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.x5c = mapped
    }

    /**
     * @param values The "x5c" (X.509 certificate chain) parameter contains a chain of one
     * or more PKIX certificates [RFC5280].  The certificate chain is
     * represented as a JSON array of certificate value strings.  Each
     * string in the array is a base64-encoded (Section 4 of [RFC4648] --
     * not base64url-encoded) DER [ITU&#46;X690&#46;1994] PKIX certificate value.
     * The PKIX certificate containing the key value MUST be the first
     * certificate.
     */
    @JvmName("dygfkkbespepbdij")
    public suspend fun x5c(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.x5c = mapped
    }

    /**
     * @param value Y coordinate for the Elliptic Curve point
     */
    @JvmName("xbhllxwjvbwreiar")
    public suspend fun y(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.y = mapped
    }

    internal fun build(): JSONWebKeyArgs = JSONWebKeyArgs(
        alg = alg,
        crv = crv,
        d = d,
        dp = dp,
        dq = dq,
        e = e,
        k = k,
        kid = kid,
        kty = kty ?: throw PulumiNullFieldException("kty"),
        n = n,
        p = p,
        q = q,
        qi = qi,
        use = use,
        x = x,
        x5c = x5c,
        y = y,
    )
}
