@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.attestation.kotlin.inputs

import com.pulumi.azurenative.attestation.inputs.JSONWebKeySetArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property keys The value of the "keys" parameter is an array of JWK values.  By
 * default, the order of the JWK values within the array does not imply
 * an order of preference among them, although applications of JWK Sets
 * can choose to assign a meaning to the order for their purposes, if
 * desired.
 */
public data class JSONWebKeySetArgs(
    public val keys: Output<List<JSONWebKeyArgs>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.attestation.inputs.JSONWebKeySetArgs> {
    override fun toJava(): com.pulumi.azurenative.attestation.inputs.JSONWebKeySetArgs =
        com.pulumi.azurenative.attestation.inputs.JSONWebKeySetArgs.builder()
            .keys(
                keys?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [JSONWebKeySetArgs].
 */
@PulumiTagMarker
public class JSONWebKeySetArgsBuilder internal constructor() {
    private var keys: Output<List<JSONWebKeyArgs>>? = null

    /**
     * @param value The value of the "keys" parameter is an array of JWK values.  By
     * default, the order of the JWK values within the array does not imply
     * an order of preference among them, although applications of JWK Sets
     * can choose to assign a meaning to the order for their purposes, if
     * desired.
     */
    @JvmName("ogovyxgsbdwijvgn")
    public suspend fun keys(`value`: Output<List<JSONWebKeyArgs>>) {
        this.keys = value
    }

    @JvmName("irxhgijwijerqjjv")
    public suspend fun keys(vararg values: Output<JSONWebKeyArgs>) {
        this.keys = Output.all(values.asList())
    }

    /**
     * @param values The value of the "keys" parameter is an array of JWK values.  By
     * default, the order of the JWK values within the array does not imply
     * an order of preference among them, although applications of JWK Sets
     * can choose to assign a meaning to the order for their purposes, if
     * desired.
     */
    @JvmName("ccvalwhbdsgcfxoj")
    public suspend fun keys(values: List<Output<JSONWebKeyArgs>>) {
        this.keys = Output.all(values)
    }

    /**
     * @param value The value of the "keys" parameter is an array of JWK values.  By
     * default, the order of the JWK values within the array does not imply
     * an order of preference among them, although applications of JWK Sets
     * can choose to assign a meaning to the order for their purposes, if
     * desired.
     */
    @JvmName("updiyseigysruoqb")
    public suspend fun keys(`value`: List<JSONWebKeyArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.keys = mapped
    }

    /**
     * @param argument The value of the "keys" parameter is an array of JWK values.  By
     * default, the order of the JWK values within the array does not imply
     * an order of preference among them, although applications of JWK Sets
     * can choose to assign a meaning to the order for their purposes, if
     * desired.
     */
    @JvmName("qsvsecpaopqkpoaw")
    public suspend fun keys(argument: List<suspend JSONWebKeyArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map { JSONWebKeyArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.keys = mapped
    }

    /**
     * @param argument The value of the "keys" parameter is an array of JWK values.  By
     * default, the order of the JWK values within the array does not imply
     * an order of preference among them, although applications of JWK Sets
     * can choose to assign a meaning to the order for their purposes, if
     * desired.
     */
    @JvmName("qxixqbahcoqsjqne")
    public suspend fun keys(vararg argument: suspend JSONWebKeyArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map { JSONWebKeyArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.keys = mapped
    }

    /**
     * @param argument The value of the "keys" parameter is an array of JWK values.  By
     * default, the order of the JWK values within the array does not imply
     * an order of preference among them, although applications of JWK Sets
     * can choose to assign a meaning to the order for their purposes, if
     * desired.
     */
    @JvmName("elrepyivkakhhngq")
    public suspend fun keys(argument: suspend JSONWebKeyArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(JSONWebKeyArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.keys = mapped
    }

    /**
     * @param values The value of the "keys" parameter is an array of JWK values.  By
     * default, the order of the JWK values within the array does not imply
     * an order of preference among them, although applications of JWK Sets
     * can choose to assign a meaning to the order for their purposes, if
     * desired.
     */
    @JvmName("jrymlfkdrevyrqyp")
    public suspend fun keys(vararg values: JSONWebKeyArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.keys = mapped
    }

    internal fun build(): JSONWebKeySetArgs = JSONWebKeySetArgs(
        keys = keys,
    )
}
