@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.authorization.kotlin

import com.pulumi.azurenative.authorization.PolicyExemptionArgs.builder
import com.pulumi.azurenative.authorization.kotlin.enums.AssignmentScopeValidation
import com.pulumi.azurenative.authorization.kotlin.enums.ExemptionCategory
import com.pulumi.azurenative.authorization.kotlin.inputs.ResourceSelectorArgs
import com.pulumi.azurenative.authorization.kotlin.inputs.ResourceSelectorArgsBuilder
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Any
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * The policy exemption.
 * Azure REST API version: 2022-07-01-preview. Prior API version in Azure Native 1.x: 2020-07-01-preview.
 * ## Example Usage
 * ### Create or update a policy exemption
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var policyExemption = new AzureNative.Authorization.PolicyExemption("policyExemption", new()
 *     {
 *         Description = "Exempt demo cluster from limit sku",
 *         DisplayName = "Exempt demo cluster",
 *         ExemptionCategory = "Waiver",
 *         Metadata =
 *         {
 *             { "reason", "Temporary exemption for a expensive VM demo" },
 *         },
 *         PolicyAssignmentId = "/subscriptions/ae640e6b-ba3e-4256-9d62-2993eecfa6f2/providers/Microsoft.Authorization/policyAssignments/CostManagement",
 *         PolicyDefinitionReferenceIds = new[]
 *         {
 *             "Limit_Skus",
 *         },
 *         PolicyExemptionName = "DemoExpensiveVM",
 *         Scope = "subscriptions/ae640e6b-ba3e-4256-9d62-2993eecfa6f2/resourceGroups/demoCluster",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/authorization/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := authorization.NewPolicyExemption(ctx, "policyExemption", &authorization.PolicyExemptionArgs{
 * 			Description:       pulumi.String("Exempt demo cluster from limit sku"),
 * 			DisplayName:       pulumi.String("Exempt demo cluster"),
 * 			ExemptionCategory: pulumi.String("Waiver"),
 * 			Metadata: pulumi.Any{
 * 				Reason: "Temporary exemption for a expensive VM demo",
 * 			},
 * 			PolicyAssignmentId: pulumi.String("/subscriptions/ae640e6b-ba3e-4256-9d62-2993eecfa6f2/providers/Microsoft.Authorization/policyAssignments/CostManagement"),
 * 			PolicyDefinitionReferenceIds: pulumi.StringArray{
 * 				pulumi.String("Limit_Skus"),
 * 			},
 * 			PolicyExemptionName: pulumi.String("DemoExpensiveVM"),
 * 			Scope:               pulumi.String("subscriptions/ae640e6b-ba3e-4256-9d62-2993eecfa6f2/resourceGroups/demoCluster"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.authorization.PolicyExemption;
 * import com.pulumi.azurenative.authorization.PolicyExemptionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var policyExemption = new PolicyExemption("policyExemption", PolicyExemptionArgs.builder()
 *             .description("Exempt demo cluster from limit sku")
 *             .displayName("Exempt demo cluster")
 *             .exemptionCategory("Waiver")
 *             .metadata(Map.of("reason", "Temporary exemption for a expensive VM demo"))
 *             .policyAssignmentId("/subscriptions/ae640e6b-ba3e-4256-9d62-2993eecfa6f2/providers/Microsoft.Authorization/policyAssignments/CostManagement")
 *             .policyDefinitionReferenceIds("Limit_Skus")
 *             .policyExemptionName("DemoExpensiveVM")
 *             .scope("subscriptions/ae640e6b-ba3e-4256-9d62-2993eecfa6f2/resourceGroups/demoCluster")
 *             .build());
 *     }
 * }
 * ```
 * ### Create or update a policy exemption with resource selectors
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var policyExemption = new AzureNative.Authorization.PolicyExemption("policyExemption", new()
 *     {
 *         AssignmentScopeValidation = "Default",
 *         Description = "Exempt demo cluster from limit sku",
 *         DisplayName = "Exempt demo cluster",
 *         ExemptionCategory = "Waiver",
 *         Metadata =
 *         {
 *             { "reason", "Temporary exemption for a expensive VM demo" },
 *         },
 *         PolicyAssignmentId = "/subscriptions/ae640e6b-ba3e-4256-9d62-2993eecfa6f2/providers/Microsoft.Authorization/policyAssignments/CostManagement",
 *         PolicyDefinitionReferenceIds = new[]
 *         {
 *             "Limit_Skus",
 *         },
 *         PolicyExemptionName = "DemoExpensiveVM",
 *         ResourceSelectors = new[]
 *         {
 *             new AzureNative.Authorization.Inputs.ResourceSelectorArgs
 *             {
 *                 Name = "SDPRegions",
 *                 Selectors = new[]
 *                 {
 *                     new AzureNative.Authorization.Inputs.SelectorArgs
 *                     {
 *                         In = new[]
 *                         {
 *                             "eastus2euap",
 *                             "centraluseuap",
 *                         },
 *                         Kind = "resourceLocation",
 *                     },
 *                 },
 *             },
 *         },
 *         Scope = "subscriptions/ae640e6b-ba3e-4256-9d62-2993eecfa6f2/resourceGroups/demoCluster",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/authorization/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := authorization.NewPolicyExemption(ctx, "policyExemption", &authorization.PolicyExemptionArgs{
 * 			AssignmentScopeValidation: pulumi.String("Default"),
 * 			Description:               pulumi.String("Exempt demo cluster from limit sku"),
 * 			DisplayName:               pulumi.String("Exempt demo cluster"),
 * 			ExemptionCategory:         pulumi.String("Waiver"),
 * 			Metadata: pulumi.Any{
 * 				Reason: "Temporary exemption for a expensive VM demo",
 * 			},
 * 			PolicyAssignmentId: pulumi.String("/subscriptions/ae640e6b-ba3e-4256-9d62-2993eecfa6f2/providers/Microsoft.Authorization/policyAssignments/CostManagement"),
 * 			PolicyDefinitionReferenceIds: pulumi.StringArray{
 * 				pulumi.String("Limit_Skus"),
 * 			},
 * 			PolicyExemptionName: pulumi.String("DemoExpensiveVM"),
 * 			ResourceSelectors: []authorization.ResourceSelectorArgs{
 * 				{
 * 					Name: pulumi.String("SDPRegions"),
 * 					Selectors: authorization.SelectorArray{
 * 						{
 * 							In: pulumi.StringArray{
 * 								pulumi.String("eastus2euap"),
 * 								pulumi.String("centraluseuap"),
 * 							},
 * 							Kind: pulumi.String("resourceLocation"),
 * 						},
 * 					},
 * 				},
 * 			},
 * 			Scope: pulumi.String("subscriptions/ae640e6b-ba3e-4256-9d62-2993eecfa6f2/resourceGroups/demoCluster"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.authorization.PolicyExemption;
 * import com.pulumi.azurenative.authorization.PolicyExemptionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var policyExemption = new PolicyExemption("policyExemption", PolicyExemptionArgs.builder()
 *             .assignmentScopeValidation("Default")
 *             .description("Exempt demo cluster from limit sku")
 *             .displayName("Exempt demo cluster")
 *             .exemptionCategory("Waiver")
 *             .metadata(Map.of("reason", "Temporary exemption for a expensive VM demo"))
 *             .policyAssignmentId("/subscriptions/ae640e6b-ba3e-4256-9d62-2993eecfa6f2/providers/Microsoft.Authorization/policyAssignments/CostManagement")
 *             .policyDefinitionReferenceIds("Limit_Skus")
 *             .policyExemptionName("DemoExpensiveVM")
 *             .resourceSelectors(Map.ofEntries(
 *                 Map.entry("name", "SDPRegions"),
 *                 Map.entry("selectors", Map.ofEntries(
 *                     Map.entry("in",
 *                         "eastus2euap",
 *                         "centraluseuap"),
 *                     Map.entry("kind", "resourceLocation")
 *                 ))
 *             ))
 *             .scope("subscriptions/ae640e6b-ba3e-4256-9d62-2993eecfa6f2/resourceGroups/demoCluster")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:authorization:PolicyExemption DemoExpensiveVM /{scope}/providers/Microsoft.Authorization/policyExemptions/{policyExemptionName}
 * ```
 * @property assignmentScopeValidation The option whether validate the exemption is at or under the assignment scope.
 * @property description The description of the policy exemption.
 * @property displayName The display name of the policy exemption.
 * @property exemptionCategory The policy exemption category. Possible values are Waiver and Mitigated.
 * @property expiresOn The expiration date and time (in UTC ISO 8601 format yyyy-MM-ddTHH:mm:ssZ) of the policy exemption.
 * @property metadata The policy exemption metadata. Metadata is an open ended object and is typically a collection of key value pairs.
 * @property policyAssignmentId The ID of the policy assignment that is being exempted.
 * @property policyDefinitionReferenceIds The policy definition reference ID list when the associated policy assignment is an assignment of a policy set definition.
 * @property policyExemptionName The name of the policy exemption to delete.
 * @property resourceSelectors The resource selector list to filter policies by resource properties.
 * @property scope The scope of the policy exemption. Valid scopes are: management group (format: '/providers/Microsoft.Management/managementGroups/{managementGroup}'), subscription (format: '/subscriptions/{subscriptionId}'), resource group (format: '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}', or resource (format: '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/[{parentResourcePath}/]{resourceType}/{resourceName}'
 */
public data class PolicyExemptionArgs(
    public val assignmentScopeValidation: Output<Either<String, AssignmentScopeValidation>>? = null,
    public val description: Output<String>? = null,
    public val displayName: Output<String>? = null,
    public val exemptionCategory: Output<Either<String, ExemptionCategory>>? = null,
    public val expiresOn: Output<String>? = null,
    public val metadata: Output<Any>? = null,
    public val policyAssignmentId: Output<String>? = null,
    public val policyDefinitionReferenceIds: Output<List<String>>? = null,
    public val policyExemptionName: Output<String>? = null,
    public val resourceSelectors: Output<List<ResourceSelectorArgs>>? = null,
    public val scope: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.authorization.PolicyExemptionArgs> {
    override fun toJava(): com.pulumi.azurenative.authorization.PolicyExemptionArgs =
        com.pulumi.azurenative.authorization.PolicyExemptionArgs.builder()
            .assignmentScopeValidation(
                assignmentScopeValidation?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .description(description?.applyValue({ args0 -> args0 }))
            .displayName(displayName?.applyValue({ args0 -> args0 }))
            .exemptionCategory(
                exemptionCategory?.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            )
            .expiresOn(expiresOn?.applyValue({ args0 -> args0 }))
            .metadata(metadata?.applyValue({ args0 -> args0 }))
            .policyAssignmentId(policyAssignmentId?.applyValue({ args0 -> args0 }))
            .policyDefinitionReferenceIds(
                policyDefinitionReferenceIds?.applyValue({ args0 ->
                    args0.map({ args0 -> args0 })
                }),
            )
            .policyExemptionName(policyExemptionName?.applyValue({ args0 -> args0 }))
            .resourceSelectors(
                resourceSelectors?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .scope(scope?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [PolicyExemptionArgs].
 */
@PulumiTagMarker
public class PolicyExemptionArgsBuilder internal constructor() {
    private var assignmentScopeValidation: Output<Either<String, AssignmentScopeValidation>>? = null

    private var description: Output<String>? = null

    private var displayName: Output<String>? = null

    private var exemptionCategory: Output<Either<String, ExemptionCategory>>? = null

    private var expiresOn: Output<String>? = null

    private var metadata: Output<Any>? = null

    private var policyAssignmentId: Output<String>? = null

    private var policyDefinitionReferenceIds: Output<List<String>>? = null

    private var policyExemptionName: Output<String>? = null

    private var resourceSelectors: Output<List<ResourceSelectorArgs>>? = null

    private var scope: Output<String>? = null

    /**
     * @param value The option whether validate the exemption is at or under the assignment scope.
     */
    @JvmName("fabuowpwxdbuatcx")
    public suspend
    fun assignmentScopeValidation(`value`: Output<Either<String, AssignmentScopeValidation>>) {
        this.assignmentScopeValidation = value
    }

    /**
     * @param value The description of the policy exemption.
     */
    @JvmName("llvkoxrkwwfwadqv")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value The display name of the policy exemption.
     */
    @JvmName("dfrnmarftdahinwq")
    public suspend fun displayName(`value`: Output<String>) {
        this.displayName = value
    }

    /**
     * @param value The policy exemption category. Possible values are Waiver and Mitigated.
     */
    @JvmName("kmyhtduvkffwyutd")
    public suspend fun exemptionCategory(`value`: Output<Either<String, ExemptionCategory>>) {
        this.exemptionCategory = value
    }

    /**
     * @param value The expiration date and time (in UTC ISO 8601 format yyyy-MM-ddTHH:mm:ssZ) of the policy exemption.
     */
    @JvmName("dxknivchxpxbsbsw")
    public suspend fun expiresOn(`value`: Output<String>) {
        this.expiresOn = value
    }

    /**
     * @param value The policy exemption metadata. Metadata is an open ended object and is typically a collection of key value pairs.
     */
    @JvmName("nowjkkcwooldircg")
    public suspend fun metadata(`value`: Output<Any>) {
        this.metadata = value
    }

    /**
     * @param value The ID of the policy assignment that is being exempted.
     */
    @JvmName("sihsjytrrebvsmlt")
    public suspend fun policyAssignmentId(`value`: Output<String>) {
        this.policyAssignmentId = value
    }

    /**
     * @param value The policy definition reference ID list when the associated policy assignment is an assignment of a policy set definition.
     */
    @JvmName("lplckpyjwflygeii")
    public suspend fun policyDefinitionReferenceIds(`value`: Output<List<String>>) {
        this.policyDefinitionReferenceIds = value
    }

    @JvmName("qwgopsvlqvdaluqc")
    public suspend fun policyDefinitionReferenceIds(vararg values: Output<String>) {
        this.policyDefinitionReferenceIds = Output.all(values.asList())
    }

    /**
     * @param values The policy definition reference ID list when the associated policy assignment is an assignment of a policy set definition.
     */
    @JvmName("hrvxknbytbungnii")
    public suspend fun policyDefinitionReferenceIds(values: List<Output<String>>) {
        this.policyDefinitionReferenceIds = Output.all(values)
    }

    /**
     * @param value The name of the policy exemption to delete.
     */
    @JvmName("akiykepvafrffdvb")
    public suspend fun policyExemptionName(`value`: Output<String>) {
        this.policyExemptionName = value
    }

    /**
     * @param value The resource selector list to filter policies by resource properties.
     */
    @JvmName("fvgsflxnjbvihqat")
    public suspend fun resourceSelectors(`value`: Output<List<ResourceSelectorArgs>>) {
        this.resourceSelectors = value
    }

    @JvmName("qxymmsryyithcebf")
    public suspend fun resourceSelectors(vararg values: Output<ResourceSelectorArgs>) {
        this.resourceSelectors = Output.all(values.asList())
    }

    /**
     * @param values The resource selector list to filter policies by resource properties.
     */
    @JvmName("kkxqpvxqucfyvtfw")
    public suspend fun resourceSelectors(values: List<Output<ResourceSelectorArgs>>) {
        this.resourceSelectors = Output.all(values)
    }

    /**
     * @param value The scope of the policy exemption. Valid scopes are: management group (format: '/providers/Microsoft.Management/managementGroups/{managementGroup}'), subscription (format: '/subscriptions/{subscriptionId}'), resource group (format: '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}', or resource (format: '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/[{parentResourcePath}/]{resourceType}/{resourceName}'
     */
    @JvmName("wwxfvgbeqcawkacy")
    public suspend fun scope(`value`: Output<String>) {
        this.scope = value
    }

    /**
     * @param value The option whether validate the exemption is at or under the assignment scope.
     */
    @JvmName("rxbtdfnraqlojldo")
    public suspend
    fun assignmentScopeValidation(`value`: Either<String, AssignmentScopeValidation>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.assignmentScopeValidation = mapped
    }

    /**
     * @param value The option whether validate the exemption is at or under the assignment scope.
     */
    @JvmName("brgyhrpumlyjsetv")
    public fun assignmentScopeValidation(`value`: String) {
        val toBeMapped = Either.ofLeft<String, AssignmentScopeValidation>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.assignmentScopeValidation = mapped
    }

    /**
     * @param value The option whether validate the exemption is at or under the assignment scope.
     */
    @JvmName("kpgqtjtuysnrnvox")
    public fun assignmentScopeValidation(`value`: AssignmentScopeValidation) {
        val toBeMapped = Either.ofRight<String, AssignmentScopeValidation>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.assignmentScopeValidation = mapped
    }

    /**
     * @param value The description of the policy exemption.
     */
    @JvmName("refenggflqjcxkpx")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value The display name of the policy exemption.
     */
    @JvmName("ylgwokjykicxdihj")
    public suspend fun displayName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.displayName = mapped
    }

    /**
     * @param value The policy exemption category. Possible values are Waiver and Mitigated.
     */
    @JvmName("taacxyedqgccbibj")
    public suspend fun exemptionCategory(`value`: Either<String, ExemptionCategory>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.exemptionCategory = mapped
    }

    /**
     * @param value The policy exemption category. Possible values are Waiver and Mitigated.
     */
    @JvmName("kigiovjrxtdemlwt")
    public fun exemptionCategory(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ExemptionCategory>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.exemptionCategory = mapped
    }

    /**
     * @param value The policy exemption category. Possible values are Waiver and Mitigated.
     */
    @JvmName("ewbyqggikbfmbebg")
    public fun exemptionCategory(`value`: ExemptionCategory) {
        val toBeMapped = Either.ofRight<String, ExemptionCategory>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.exemptionCategory = mapped
    }

    /**
     * @param value The expiration date and time (in UTC ISO 8601 format yyyy-MM-ddTHH:mm:ssZ) of the policy exemption.
     */
    @JvmName("jdrwyintjpmjopgl")
    public suspend fun expiresOn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.expiresOn = mapped
    }

    /**
     * @param value The policy exemption metadata. Metadata is an open ended object and is typically a collection of key value pairs.
     */
    @JvmName("llklakrkoihbxkur")
    public suspend fun metadata(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.metadata = mapped
    }

    /**
     * @param value The ID of the policy assignment that is being exempted.
     */
    @JvmName("udvvdagaolillqas")
    public suspend fun policyAssignmentId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.policyAssignmentId = mapped
    }

    /**
     * @param value The policy definition reference ID list when the associated policy assignment is an assignment of a policy set definition.
     */
    @JvmName("tjcihnjuybvocgxd")
    public suspend fun policyDefinitionReferenceIds(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.policyDefinitionReferenceIds = mapped
    }

    /**
     * @param values The policy definition reference ID list when the associated policy assignment is an assignment of a policy set definition.
     */
    @JvmName("osuovhvnjtgqivkf")
    public suspend fun policyDefinitionReferenceIds(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.policyDefinitionReferenceIds = mapped
    }

    /**
     * @param value The name of the policy exemption to delete.
     */
    @JvmName("evgfjycshugympuq")
    public suspend fun policyExemptionName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.policyExemptionName = mapped
    }

    /**
     * @param value The resource selector list to filter policies by resource properties.
     */
    @JvmName("jjytuiodoecsjfoh")
    public suspend fun resourceSelectors(`value`: List<ResourceSelectorArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceSelectors = mapped
    }

    /**
     * @param argument The resource selector list to filter policies by resource properties.
     */
    @JvmName("swokrjrvchwooshb")
    public suspend
    fun resourceSelectors(argument: List<suspend ResourceSelectorArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ResourceSelectorArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.resourceSelectors = mapped
    }

    /**
     * @param argument The resource selector list to filter policies by resource properties.
     */
    @JvmName("pyhyfkmrrnlhwiny")
    public suspend fun resourceSelectors(
        vararg
        argument: suspend ResourceSelectorArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            ResourceSelectorArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.resourceSelectors = mapped
    }

    /**
     * @param argument The resource selector list to filter policies by resource properties.
     */
    @JvmName("huqpjhnbptjodkvx")
    public suspend fun resourceSelectors(argument: suspend ResourceSelectorArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(ResourceSelectorArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.resourceSelectors = mapped
    }

    /**
     * @param values The resource selector list to filter policies by resource properties.
     */
    @JvmName("fmyhavifhafsocxt")
    public suspend fun resourceSelectors(vararg values: ResourceSelectorArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.resourceSelectors = mapped
    }

    /**
     * @param value The scope of the policy exemption. Valid scopes are: management group (format: '/providers/Microsoft.Management/managementGroups/{managementGroup}'), subscription (format: '/subscriptions/{subscriptionId}'), resource group (format: '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}', or resource (format: '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/[{parentResourcePath}/]{resourceType}/{resourceName}'
     */
    @JvmName("gvwlmdornhmdwfix")
    public suspend fun scope(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.scope = mapped
    }

    internal fun build(): PolicyExemptionArgs = PolicyExemptionArgs(
        assignmentScopeValidation = assignmentScopeValidation,
        description = description,
        displayName = displayName,
        exemptionCategory = exemptionCategory,
        expiresOn = expiresOn,
        metadata = metadata,
        policyAssignmentId = policyAssignmentId,
        policyDefinitionReferenceIds = policyDefinitionReferenceIds,
        policyExemptionName = policyExemptionName,
        resourceSelectors = resourceSelectors,
        scope = scope,
    )
}
