@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.authorization.kotlin

import com.pulumi.azurenative.authorization.kotlin.outputs.ParameterDefinitionsValueResponse
import com.pulumi.azurenative.authorization.kotlin.outputs.PolicyDefinitionGroupResponse
import com.pulumi.azurenative.authorization.kotlin.outputs.PolicyDefinitionReferenceResponse
import com.pulumi.azurenative.authorization.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Any
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.azurenative.authorization.kotlin.outputs.ParameterDefinitionsValueResponse.Companion.toKotlin as parameterDefinitionsValueResponseToKotlin
import com.pulumi.azurenative.authorization.kotlin.outputs.PolicyDefinitionGroupResponse.Companion.toKotlin as policyDefinitionGroupResponseToKotlin
import com.pulumi.azurenative.authorization.kotlin.outputs.PolicyDefinitionReferenceResponse.Companion.toKotlin as policyDefinitionReferenceResponseToKotlin
import com.pulumi.azurenative.authorization.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [PolicySetDefinitionAtManagementGroup].
 */
@PulumiTagMarker
public class PolicySetDefinitionAtManagementGroupResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: PolicySetDefinitionAtManagementGroupArgs =
        PolicySetDefinitionAtManagementGroupArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend
    fun args(block: suspend PolicySetDefinitionAtManagementGroupArgsBuilder.() -> Unit) {
        val builder = PolicySetDefinitionAtManagementGroupArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): PolicySetDefinitionAtManagementGroup {
        val builtJavaResource =
            com.pulumi.azurenative.authorization.PolicySetDefinitionAtManagementGroup(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return PolicySetDefinitionAtManagementGroup(builtJavaResource)
    }
}

/**
 * The policy set definition.
 * Azure REST API version: 2021-06-01. Prior API version in Azure Native 1.x: 2020-09-01.
 * Other available API versions: 2019-06-01, 2023-04-01.
 * ## Example Usage
 * ### Create or update a policy set definition at management group level
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var policySetDefinitionAtManagementGroup = new AzureNative.Authorization.PolicySetDefinitionAtManagementGroup("policySetDefinitionAtManagementGroup", new()
 *     {
 *         Description = "Policies to enforce low cost storage SKUs",
 *         DisplayName = "Cost Management",
 *         ManagementGroupId = "MyManagementGroup",
 *         Metadata =
 *         {
 *             { "category", "Cost Management" },
 *         },
 *         PolicyDefinitions = new[]
 *         {
 *             new AzureNative.Authorization.Inputs.PolicyDefinitionReferenceArgs
 *             {
 *                 Parameters =
 *                 {
 *                     { "listOfAllowedSKUs", new AzureNative.Authorization.Inputs.ParameterValuesValueArgs
 *                     {
 *                         Value = new[]
 *                         {
 *                             "Standard_GRS",
 *                             "Standard_LRS",
 *                         },
 *                     } },
 *                 },
 *                 PolicyDefinitionId = "/providers/Microsoft.Management/managementgroups/MyManagementGroup/providers/Microsoft.Authorization/policyDefinitions/7433c107-6db4-4ad1-b57a-a76dce0154a1",
 *                 PolicyDefinitionReferenceId = "Limit_Skus",
 *             },
 *             new AzureNative.Authorization.Inputs.PolicyDefinitionReferenceArgs
 *             {
 *                 Parameters =
 *                 {
 *                     { "prefix", new AzureNative.Authorization.Inputs.ParameterValuesValueArgs
 *                     {
 *                         Value = "DeptA",
 *                     } },
 *                     { "suffix", new AzureNative.Authorization.Inputs.ParameterValuesValueArgs
 *                     {
 *                         Value = "-LC",
 *                     } },
 *                 },
 *                 PolicyDefinitionId = "/providers/Microsoft.Management/managementgroups/MyManagementGroup/providers/Microsoft.Authorization/policyDefinitions/ResourceNaming",
 *                 PolicyDefinitionReferenceId = "Resource_Naming",
 *             },
 *         },
 *         PolicySetDefinitionName = "CostManagement",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/authorization/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := authorization.NewPolicySetDefinitionAtManagementGroup(ctx, "policySetDefinitionAtManagementGroup", &authorization.PolicySetDefinitionAtManagementGroupArgs{
 * 			Description:       pulumi.String("Policies to enforce low cost storage SKUs"),
 * 			DisplayName:       pulumi.String("Cost Management"),
 * 			ManagementGroupId: pulumi.String("MyManagementGroup"),
 * 			Metadata: pulumi.Any{
 * 				Category: "Cost Management",
 * 			},
 * 			PolicyDefinitions: []authorization.PolicyDefinitionReferenceArgs{
 * 				{
 * 					Parameters: {
 * 						"listOfAllowedSKUs": {
 * 							Value: pulumi.Any{
 * 								"Standard_GRS",
 * 								"Standard_LRS",
 * 							},
 * 						},
 * 					},
 * 					PolicyDefinitionId:          pulumi.String("/providers/Microsoft.Management/managementgroups/MyManagementGroup/providers/Microsoft.Authorization/policyDefinitions/7433c107-6db4-4ad1-b57a-a76dce0154a1"),
 * 					PolicyDefinitionReferenceId: pulumi.String("Limit_Skus"),
 * 				},
 * 				{
 * 					Parameters: {
 * 						"prefix": {
 * 							Value: pulumi.Any("DeptA"),
 * 						},
 * 						"suffix": {
 * 							Value: pulumi.Any("-LC"),
 * 						},
 * 					},
 * 					PolicyDefinitionId:          pulumi.String("/providers/Microsoft.Management/managementgroups/MyManagementGroup/providers/Microsoft.Authorization/policyDefinitions/ResourceNaming"),
 * 					PolicyDefinitionReferenceId: pulumi.String("Resource_Naming"),
 * 				},
 * 			},
 * 			PolicySetDefinitionName: pulumi.String("CostManagement"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.authorization.PolicySetDefinitionAtManagementGroup;
 * import com.pulumi.azurenative.authorization.PolicySetDefinitionAtManagementGroupArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var policySetDefinitionAtManagementGroup = new PolicySetDefinitionAtManagementGroup("policySetDefinitionAtManagementGroup", PolicySetDefinitionAtManagementGroupArgs.builder()
 *             .description("Policies to enforce low cost storage SKUs")
 *             .displayName("Cost Management")
 *             .managementGroupId("MyManagementGroup")
 *             .metadata(Map.of("category", "Cost Management"))
 *             .policyDefinitions(
 *                 Map.ofEntries(
 *                     Map.entry("parameters", Map.of("listOfAllowedSKUs", Map.of("value",
 *                         "Standard_GRS",
 *                         "Standard_LRS"))),
 *                     Map.entry("policyDefinitionId", "/providers/Microsoft.Management/managementgroups/MyManagementGroup/providers/Microsoft.Authorization/policyDefinitions/7433c107-6db4-4ad1-b57a-a76dce0154a1"),
 *                     Map.entry("policyDefinitionReferenceId", "Limit_Skus")
 *                 ),
 *                 Map.ofEntries(
 *                     Map.entry("parameters", Map.ofEntries(
 *                         Map.entry("prefix", Map.of("value", "DeptA")),
 *                         Map.entry("suffix", Map.of("value", "-LC"))
 *                     )),
 *                     Map.entry("policyDefinitionId", "/providers/Microsoft.Management/managementgroups/MyManagementGroup/providers/Microsoft.Authorization/policyDefinitions/ResourceNaming"),
 *                     Map.entry("policyDefinitionReferenceId", "Resource_Naming")
 *                 ))
 *             .policySetDefinitionName("CostManagement")
 *             .build());
 *     }
 * }
 * ```
 * ### Create or update a policy set definition with groups at management group level
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var policySetDefinitionAtManagementGroup = new AzureNative.Authorization.PolicySetDefinitionAtManagementGroup("policySetDefinitionAtManagementGroup", new()
 *     {
 *         Description = "Policies to enforce low cost storage SKUs",
 *         DisplayName = "Cost Management",
 *         ManagementGroupId = "MyManagementGroup",
 *         Metadata =
 *         {
 *             { "category", "Cost Management" },
 *         },
 *         PolicyDefinitionGroups = new[]
 *         {
 *             new AzureNative.Authorization.Inputs.PolicyDefinitionGroupArgs
 *             {
 *                 Description = "Policies designed to control spend within a subscription.",
 *                 DisplayName = "Cost Management Policies",
 *                 Name = "CostSaving",
 *             },
 *             new AzureNative.Authorization.Inputs.PolicyDefinitionGroupArgs
 *             {
 *                 Description = "Policies that help enforce resource organization standards within a subscription.",
 *                 DisplayName = "Organizational Policies",
 *                 Name = "Organizational",
 *             },
 *         },
 *         PolicyDefinitions = new[]
 *         {
 *             new AzureNative.Authorization.Inputs.PolicyDefinitionReferenceArgs
 *             {
 *                 GroupNames = new[]
 *                 {
 *                     "CostSaving",
 *                 },
 *                 Parameters =
 *                 {
 *                     { "listOfAllowedSKUs", new AzureNative.Authorization.Inputs.ParameterValuesValueArgs
 *                     {
 *                         Value = new[]
 *                         {
 *                             "Standard_GRS",
 *                             "Standard_LRS",
 *                         },
 *                     } },
 *                 },
 *                 PolicyDefinitionId = "/subscriptions/ae640e6b-ba3e-4256-9d62-2993eecfa6f2/providers/Microsoft.Authorization/policyDefinitions/7433c107-6db4-4ad1-b57a-a76dce0154a1",
 *                 PolicyDefinitionReferenceId = "Limit_Skus",
 *             },
 *             new AzureNative.Authorization.Inputs.PolicyDefinitionReferenceArgs
 *             {
 *                 GroupNames = new[]
 *                 {
 *                     "Organizational",
 *                 },
 *                 Parameters =
 *                 {
 *                     { "prefix", new AzureNative.Authorization.Inputs.ParameterValuesValueArgs
 *                     {
 *                         Value = "DeptA",
 *                     } },
 *                     { "suffix", new AzureNative.Authorization.Inputs.ParameterValuesValueArgs
 *                     {
 *                         Value = "-LC",
 *                     } },
 *                 },
 *                 PolicyDefinitionId = "/subscriptions/ae640e6b-ba3e-4256-9d62-2993eecfa6f2/providers/Microsoft.Authorization/policyDefinitions/ResourceNaming",
 *                 PolicyDefinitionReferenceId = "Resource_Naming",
 *             },
 *         },
 *         PolicySetDefinitionName = "CostManagement",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/authorization/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := authorization.NewPolicySetDefinitionAtManagementGroup(ctx, "policySetDefinitionAtManagementGroup", &authorization.PolicySetDefinitionAtManagementGroupArgs{
 * 			Description:       pulumi.String("Policies to enforce low cost storage SKUs"),
 * 			DisplayName:       pulumi.String("Cost Management"),
 * 			ManagementGroupId: pulumi.String("MyManagementGroup"),
 * 			Metadata: pulumi.Any{
 * 				Category: "Cost Management",
 * 			},
 * 			PolicyDefinitionGroups: []authorization.PolicyDefinitionGroupArgs{
 * 				{
 * 					Description: pulumi.String("Policies designed to control spend within a subscription."),
 * 					DisplayName: pulumi.String("Cost Management Policies"),
 * 					Name:        pulumi.String("CostSaving"),
 * 				},
 * 				{
 * 					Description: pulumi.String("Policies that help enforce resource organization standards within a subscription."),
 * 					DisplayName: pulumi.String("Organizational Policies"),
 * 					Name:        pulumi.String("Organizational"),
 * 				},
 * 			},
 * 			PolicyDefinitions: []authorization.PolicyDefinitionReferenceArgs{
 * 				{
 * 					GroupNames: pulumi.StringArray{
 * 						pulumi.String("CostSaving"),
 * 					},
 * 					Parameters: {
 * 						"listOfAllowedSKUs": {
 * 							Value: pulumi.Any{
 * 								"Standard_GRS",
 * 								"Standard_LRS",
 * 							},
 * 						},
 * 					},
 * 					PolicyDefinitionId:          pulumi.String("/subscriptions/ae640e6b-ba3e-4256-9d62-2993eecfa6f2/providers/Microsoft.Authorization/policyDefinitions/7433c107-6db4-4ad1-b57a-a76dce0154a1"),
 * 					PolicyDefinitionReferenceId: pulumi.String("Limit_Skus"),
 * 				},
 * 				{
 * 					GroupNames: pulumi.StringArray{
 * 						pulumi.String("Organizational"),
 * 					},
 * 					Parameters: {
 * 						"prefix": {
 * 							Value: pulumi.Any("DeptA"),
 * 						},
 * 						"suffix": {
 * 							Value: pulumi.Any("-LC"),
 * 						},
 * 					},
 * 					PolicyDefinitionId:          pulumi.String("/subscriptions/ae640e6b-ba3e-4256-9d62-2993eecfa6f2/providers/Microsoft.Authorization/policyDefinitions/ResourceNaming"),
 * 					PolicyDefinitionReferenceId: pulumi.String("Resource_Naming"),
 * 				},
 * 			},
 * 			PolicySetDefinitionName: pulumi.String("CostManagement"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.authorization.PolicySetDefinitionAtManagementGroup;
 * import com.pulumi.azurenative.authorization.PolicySetDefinitionAtManagementGroupArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var policySetDefinitionAtManagementGroup = new PolicySetDefinitionAtManagementGroup("policySetDefinitionAtManagementGroup", PolicySetDefinitionAtManagementGroupArgs.builder()
 *             .description("Policies to enforce low cost storage SKUs")
 *             .displayName("Cost Management")
 *             .managementGroupId("MyManagementGroup")
 *             .metadata(Map.of("category", "Cost Management"))
 *             .policyDefinitionGroups(
 *                 Map.ofEntries(
 *                     Map.entry("description", "Policies designed to control spend within a subscription."),
 *                     Map.entry("displayName", "Cost Management Policies"),
 *                     Map.entry("name", "CostSaving")
 *                 ),
 *                 Map.ofEntries(
 *                     Map.entry("description", "Policies that help enforce resource organization standards within a subscription."),
 *                     Map.entry("displayName", "Organizational Policies"),
 *                     Map.entry("name", "Organizational")
 *                 ))
 *             .policyDefinitions(
 *                 Map.ofEntries(
 *                     Map.entry("groupNames", "CostSaving"),
 *                     Map.entry("parameters", Map.of("listOfAllowedSKUs", Map.of("value",
 *                         "Standard_GRS",
 *                         "Standard_LRS"))),
 *                     Map.entry("policyDefinitionId", "/subscriptions/ae640e6b-ba3e-4256-9d62-2993eecfa6f2/providers/Microsoft.Authorization/policyDefinitions/7433c107-6db4-4ad1-b57a-a76dce0154a1"),
 *                     Map.entry("policyDefinitionReferenceId", "Limit_Skus")
 *                 ),
 *                 Map.ofEntries(
 *                     Map.entry("groupNames", "Organizational"),
 *                     Map.entry("parameters", Map.ofEntries(
 *                         Map.entry("prefix", Map.of("value", "DeptA")),
 *                         Map.entry("suffix", Map.of("value", "-LC"))
 *                     )),
 *                     Map.entry("policyDefinitionId", "/subscriptions/ae640e6b-ba3e-4256-9d62-2993eecfa6f2/providers/Microsoft.Authorization/policyDefinitions/ResourceNaming"),
 *                     Map.entry("policyDefinitionReferenceId", "Resource_Naming")
 *                 ))
 *             .policySetDefinitionName("CostManagement")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:authorization:PolicySetDefinitionAtManagementGroup CostManagement /providers/Microsoft.Management/managementGroups/{managementGroupId}/providers/Microsoft.Authorization/policySetDefinitions/{policySetDefinitionName}
 * ```
 */
public class PolicySetDefinitionAtManagementGroup internal constructor(
    override val javaResource:
    com.pulumi.azurenative.authorization.PolicySetDefinitionAtManagementGroup,
) : KotlinCustomResource(javaResource, PolicySetDefinitionAtManagementGroupMapper) {
    /**
     * The policy set definition description.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The display name of the policy set definition.
     */
    public val displayName: Output<String>?
        get() = javaResource.displayName().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The policy set definition metadata.  Metadata is an open ended object and is typically a collection of key value pairs.
     */
    public val metadata: Output<Any>?
        get() = javaResource.metadata().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The name of the policy set definition.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The policy set definition parameters that can be used in policy definition references.
     */
    public val parameters: Output<Map<String, ParameterDefinitionsValueResponse>>?
        get() = javaResource.parameters().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(
                        args0.value.let({ args0 ->
                            parameterDefinitionsValueResponseToKotlin(args0)
                        }),
                    )
                }).toMap()
            }).orElse(null)
        })

    /**
     * The metadata describing groups of policy definition references within the policy set definition.
     */
    public val policyDefinitionGroups: Output<List<PolicyDefinitionGroupResponse>>?
        get() = javaResource.policyDefinitionGroups().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 ->
                        policyDefinitionGroupResponseToKotlin(args0)
                    })
                })
            }).orElse(null)
        })

    /**
     * An array of policy definition references.
     */
    public val policyDefinitions: Output<List<PolicyDefinitionReferenceResponse>>
        get() = javaResource.policyDefinitions().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> policyDefinitionReferenceResponseToKotlin(args0) })
            })
        })

    /**
     * The type of policy definition. Possible values are NotSpecified, BuiltIn, Custom, and Static.
     */
    public val policyType: Output<String>?
        get() = javaResource.policyType().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The system metadata relating to this resource.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * The type of the resource (Microsoft.Authorization/policySetDefinitions).
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object PolicySetDefinitionAtManagementGroupMapper :
    ResourceMapper<PolicySetDefinitionAtManagementGroup> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.authorization.PolicySetDefinitionAtManagementGroup::class == javaResource::class

    override fun map(javaResource: Resource): PolicySetDefinitionAtManagementGroup =
        PolicySetDefinitionAtManagementGroup(
            javaResource as
                com.pulumi.azurenative.authorization.PolicySetDefinitionAtManagementGroup,
        )
}

/**
 * @see [PolicySetDefinitionAtManagementGroup].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [PolicySetDefinitionAtManagementGroup].
 */
public suspend fun policySetDefinitionAtManagementGroup(
    name: String,
    block: suspend PolicySetDefinitionAtManagementGroupResourceBuilder.() -> Unit,
):
    PolicySetDefinitionAtManagementGroup {
    val builder = PolicySetDefinitionAtManagementGroupResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [PolicySetDefinitionAtManagementGroup].
 * @param name The _unique_ name of the resulting resource.
 */
public fun policySetDefinitionAtManagementGroup(name: String):
    PolicySetDefinitionAtManagementGroup {
    val builder = PolicySetDefinitionAtManagementGroupResourceBuilder()
    builder.name(name)
    return builder.build()
}
