@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.authorization.kotlin

import com.pulumi.azurenative.authorization.kotlin.outputs.PrivateLinkAssociationPropertiesExpandedResponse
import com.pulumi.azurenative.authorization.kotlin.outputs.PrivateLinkAssociationPropertiesExpandedResponse.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [PrivateLinkAssociation].
 */
@PulumiTagMarker
public class PrivateLinkAssociationResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: PrivateLinkAssociationArgs = PrivateLinkAssociationArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend PrivateLinkAssociationArgsBuilder.() -> Unit) {
        val builder = PrivateLinkAssociationArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): PrivateLinkAssociation {
        val builtJavaResource =
            com.pulumi.azurenative.authorization.PrivateLinkAssociation(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return PrivateLinkAssociation(builtJavaResource)
    }
}

/**
 *
 * Azure REST API version: 2020-05-01. Prior API version in Azure Native 1.x: 2020-05-01.
 * ## Example Usage
 * ### Create a private link association, associate scope to rmpl.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var privateLinkAssociation = new AzureNative.Authorization.PrivateLinkAssociation("privateLinkAssociation", new()
 *     {
 *         GroupId = "my-management-group",
 *         PlaId = "00000000-0000-0000-0000-000000000000",
 *         Properties = new AzureNative.Authorization.Inputs.PrivateLinkAssociationPropertiesArgs
 *         {
 *             PrivateLink = "00000000-0000-0000-0000-000000000000",
 *             PublicNetworkAccess = "Enabled",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/authorization/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := authorization.NewPrivateLinkAssociation(ctx, "privateLinkAssociation", &authorization.PrivateLinkAssociationArgs{
 * 			GroupId: pulumi.String("my-management-group"),
 * 			PlaId:   pulumi.String("00000000-0000-0000-0000-000000000000"),
 * 			Properties: &authorization.PrivateLinkAssociationPropertiesArgs{
 * 				PrivateLink:         pulumi.String("00000000-0000-0000-0000-000000000000"),
 * 				PublicNetworkAccess: pulumi.String("Enabled"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.authorization.PrivateLinkAssociation;
 * import com.pulumi.azurenative.authorization.PrivateLinkAssociationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var privateLinkAssociation = new PrivateLinkAssociation("privateLinkAssociation", PrivateLinkAssociationArgs.builder()
 *             .groupId("my-management-group")
 *             .plaId("00000000-0000-0000-0000-000000000000")
 *             .properties(Map.ofEntries(
 *                 Map.entry("privateLink", "00000000-0000-0000-0000-000000000000"),
 *                 Map.entry("publicNetworkAccess", "Enabled")
 *             ))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:authorization:PrivateLinkAssociation my-pla /providers/Microsoft.Management/managementGroups/{groupId}/providers/Microsoft.Authorization/privateLinkAssociations/{plaId}
 * ```
 */
public class PrivateLinkAssociation internal constructor(
    override val javaResource: com.pulumi.azurenative.authorization.PrivateLinkAssociation,
) : KotlinCustomResource(javaResource, PrivateLinkAssociationMapper) {
    /**
     * The pla name.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The private link association properties.
     */
    public val properties: Output<PrivateLinkAssociationPropertiesExpandedResponse>
        get() = javaResource.properties().applyValue({ args0 -> args0.let({ args0 -> toKotlin(args0) }) })

    /**
     * The operation type.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object PrivateLinkAssociationMapper : ResourceMapper<PrivateLinkAssociation> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.authorization.PrivateLinkAssociation::class == javaResource::class

    override fun map(javaResource: Resource): PrivateLinkAssociation =
        PrivateLinkAssociation(
            javaResource as
                com.pulumi.azurenative.authorization.PrivateLinkAssociation,
        )
}

/**
 * @see [PrivateLinkAssociation].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [PrivateLinkAssociation].
 */
public suspend fun privateLinkAssociation(
    name: String,
    block: suspend PrivateLinkAssociationResourceBuilder.() -> Unit,
): PrivateLinkAssociation {
    val builder = PrivateLinkAssociationResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [PrivateLinkAssociation].
 * @param name The _unique_ name of the resulting resource.
 */
public fun privateLinkAssociation(name: String): PrivateLinkAssociation {
    val builder = PrivateLinkAssociationResourceBuilder()
    builder.name(name)
    return builder.build()
}
