@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.authorization.kotlin

import com.pulumi.azurenative.authorization.ResourceManagementPrivateLinkArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * Azure REST API version: 2020-05-01. Prior API version in Azure Native 1.x: 2020-05-01.
 * ## Example Usage
 * ### Create Resource Management Private Link.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var resourceManagementPrivateLink = new AzureNative.Authorization.ResourceManagementPrivateLink("resourceManagementPrivateLink", new()
 *     {
 *         Location = "eastus",
 *         ResourceGroupName = "my-resource-group",
 *         RmplName = "my-rmplName",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/authorization/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := authorization.NewResourceManagementPrivateLink(ctx, "resourceManagementPrivateLink", &authorization.ResourceManagementPrivateLinkArgs{
 * 			Location:          pulumi.String("eastus"),
 * 			ResourceGroupName: pulumi.String("my-resource-group"),
 * 			RmplName:          pulumi.String("my-rmplName"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.authorization.ResourceManagementPrivateLink;
 * import com.pulumi.azurenative.authorization.ResourceManagementPrivateLinkArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var resourceManagementPrivateLink = new ResourceManagementPrivateLink("resourceManagementPrivateLink", ResourceManagementPrivateLinkArgs.builder()
 *             .location("eastus")
 *             .resourceGroupName("my-resource-group")
 *             .rmplName("my-rmplName")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:authorization:ResourceManagementPrivateLink my-pla /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Authorization/resourceManagementPrivateLinks/{rmplName}
 * ```
 * @property location the region to create private link association.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property rmplName The name of the resource management private link.
 */
public data class ResourceManagementPrivateLinkArgs(
    public val location: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val rmplName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.authorization.ResourceManagementPrivateLinkArgs> {
    override fun toJava(): com.pulumi.azurenative.authorization.ResourceManagementPrivateLinkArgs =
        com.pulumi.azurenative.authorization.ResourceManagementPrivateLinkArgs.builder()
            .location(location?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .rmplName(rmplName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ResourceManagementPrivateLinkArgs].
 */
@PulumiTagMarker
public class ResourceManagementPrivateLinkArgsBuilder internal constructor() {
    private var location: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var rmplName: Output<String>? = null

    /**
     * @param value the region to create private link association.
     */
    @JvmName("ehmelihwfsuxxxsl")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("pywpjmjrxwaeocay")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The name of the resource management private link.
     */
    @JvmName("irrsgkikcenpavpo")
    public suspend fun rmplName(`value`: Output<String>) {
        this.rmplName = value
    }

    /**
     * @param value the region to create private link association.
     */
    @JvmName("jkjrfvtehlhloade")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("fdmqijgvvuyeytwg")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the resource management private link.
     */
    @JvmName("efxpmwojmafocymw")
    public suspend fun rmplName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.rmplName = mapped
    }

    internal fun build(): ResourceManagementPrivateLinkArgs = ResourceManagementPrivateLinkArgs(
        location = location,
        resourceGroupName = resourceGroupName,
        rmplName = rmplName,
    )
}
