@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.authorization.kotlin

import com.pulumi.azurenative.authorization.kotlin.outputs.PermissionResponse
import com.pulumi.azurenative.authorization.kotlin.outputs.PermissionResponse.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List

/**
 * Builder for [RoleDefinition].
 */
@PulumiTagMarker
public class RoleDefinitionResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: RoleDefinitionArgs = RoleDefinitionArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend RoleDefinitionArgsBuilder.() -> Unit) {
        val builder = RoleDefinitionArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): RoleDefinition {
        val builtJavaResource =
            com.pulumi.azurenative.authorization.RoleDefinition(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return RoleDefinition(builtJavaResource)
    }
}

/**
 * Role definition.
 * Azure REST API version: 2022-05-01-preview. Prior API version in Azure Native 1.x: 2018-01-01-preview.
 * ## Example Usage
 * ### Create role definition
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var roleDefinition = new AzureNative.Authorization.RoleDefinition("roleDefinition", new()
 *     {
 *         RoleDefinitionId = "roleDefinitionId",
 *         Scope = "scope",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/authorization/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := authorization.NewRoleDefinition(ctx, "roleDefinition", &authorization.RoleDefinitionArgs{
 * 			RoleDefinitionId: pulumi.String("roleDefinitionId"),
 * 			Scope:            pulumi.String("scope"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.authorization.RoleDefinition;
 * import com.pulumi.azurenative.authorization.RoleDefinitionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var roleDefinition = new RoleDefinition("roleDefinition", RoleDefinitionArgs.builder()
 *             .roleDefinitionId("roleDefinitionId")
 *             .scope("scope")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:authorization:RoleDefinition roleDefinitionId /{scope}/providers/Microsoft.Authorization/roleDefinitions/{roleDefinitionId}
 * ```
 */
public class RoleDefinition internal constructor(
    override val javaResource: com.pulumi.azurenative.authorization.RoleDefinition,
) : KotlinCustomResource(javaResource, RoleDefinitionMapper) {
    /**
     * Role definition assignable scopes.
     */
    public val assignableScopes: Output<List<String>>?
        get() = javaResource.assignableScopes().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 -> args0 })
            }).orElse(null)
        })

    /**
     * Id of the user who created the assignment
     */
    public val createdBy: Output<String>
        get() = javaResource.createdBy().applyValue({ args0 -> args0 })

    /**
     * Time it was created
     */
    public val createdOn: Output<String>
        get() = javaResource.createdOn().applyValue({ args0 -> args0 })

    /**
     * The role definition description.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The role definition name.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Role definition permissions.
     */
    public val permissions: Output<List<PermissionResponse>>?
        get() = javaResource.permissions().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 -> toKotlin(args0) })
                })
            }).orElse(null)
        })

    /**
     * The role name.
     */
    public val roleName: Output<String>?
        get() = javaResource.roleName().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The role type.
     */
    public val roleType: Output<String>?
        get() = javaResource.roleType().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The role definition type.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })

    /**
     * Id of the user who updated the assignment
     */
    public val updatedBy: Output<String>
        get() = javaResource.updatedBy().applyValue({ args0 -> args0 })

    /**
     * Time it was updated
     */
    public val updatedOn: Output<String>
        get() = javaResource.updatedOn().applyValue({ args0 -> args0 })
}

public object RoleDefinitionMapper : ResourceMapper<RoleDefinition> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.authorization.RoleDefinition::class == javaResource::class

    override fun map(javaResource: Resource): RoleDefinition = RoleDefinition(
        javaResource as
            com.pulumi.azurenative.authorization.RoleDefinition,
    )
}

/**
 * @see [RoleDefinition].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [RoleDefinition].
 */
public suspend fun roleDefinition(
    name: String,
    block: suspend RoleDefinitionResourceBuilder.() -> Unit,
): RoleDefinition {
    val builder = RoleDefinitionResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [RoleDefinition].
 * @param name The _unique_ name of the resulting resource.
 */
public fun roleDefinition(name: String): RoleDefinition {
    val builder = RoleDefinitionResourceBuilder()
    builder.name(name)
    return builder.build()
}
