@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.authorization.kotlin

import com.pulumi.azurenative.authorization.RoleManagementPolicyAssignmentArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Role management policy
 * Azure REST API version: 2020-10-01. Prior API version in Azure Native 1.x: 2020-10-01.
 * Other available API versions: 2020-10-01-preview.
 * ## Example Usage
 * ### PutRoleManagementPolicyAssignment
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var roleManagementPolicyAssignment = new AzureNative.Authorization.RoleManagementPolicyAssignment("roleManagementPolicyAssignment", new()
 *     {
 *         PolicyId = "/subscriptions/129ff972-28f8-46b8-a726-e497be039368/providers/Microsoft.Authorization/roleManagementPolicies/b959d571-f0b5-4042-88a7-01be6cb22db9",
 *         RoleDefinitionId = "/subscriptions/129ff972-28f8-46b8-a726-e497be039368/providers/Microsoft.Authorization/roleDefinitions/a1705bd2-3a8f-45a5-8683-466fcfd5cc24",
 *         RoleManagementPolicyAssignmentName = "b959d571-f0b5-4042-88a7-01be6cb22db9_a1705bd2-3a8f-45a5-8683-466fcfd5cc24",
 *         Scope = "providers/Microsoft.Subscription/subscriptions/129ff972-28f8-46b8-a726-e497be039368",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/authorization/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := authorization.NewRoleManagementPolicyAssignment(ctx, "roleManagementPolicyAssignment", &authorization.RoleManagementPolicyAssignmentArgs{
 * 			PolicyId:                           pulumi.String("/subscriptions/129ff972-28f8-46b8-a726-e497be039368/providers/Microsoft.Authorization/roleManagementPolicies/b959d571-f0b5-4042-88a7-01be6cb22db9"),
 * 			RoleDefinitionId:                   pulumi.String("/subscriptions/129ff972-28f8-46b8-a726-e497be039368/providers/Microsoft.Authorization/roleDefinitions/a1705bd2-3a8f-45a5-8683-466fcfd5cc24"),
 * 			RoleManagementPolicyAssignmentName: pulumi.String("b959d571-f0b5-4042-88a7-01be6cb22db9_a1705bd2-3a8f-45a5-8683-466fcfd5cc24"),
 * 			Scope:                              pulumi.String("providers/Microsoft.Subscription/subscriptions/129ff972-28f8-46b8-a726-e497be039368"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.authorization.RoleManagementPolicyAssignment;
 * import com.pulumi.azurenative.authorization.RoleManagementPolicyAssignmentArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var roleManagementPolicyAssignment = new RoleManagementPolicyAssignment("roleManagementPolicyAssignment", RoleManagementPolicyAssignmentArgs.builder()
 *             .policyId("/subscriptions/129ff972-28f8-46b8-a726-e497be039368/providers/Microsoft.Authorization/roleManagementPolicies/b959d571-f0b5-4042-88a7-01be6cb22db9")
 *             .roleDefinitionId("/subscriptions/129ff972-28f8-46b8-a726-e497be039368/providers/Microsoft.Authorization/roleDefinitions/a1705bd2-3a8f-45a5-8683-466fcfd5cc24")
 *             .roleManagementPolicyAssignmentName("b959d571-f0b5-4042-88a7-01be6cb22db9_a1705bd2-3a8f-45a5-8683-466fcfd5cc24")
 *             .scope("providers/Microsoft.Subscription/subscriptions/129ff972-28f8-46b8-a726-e497be039368")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:authorization:RoleManagementPolicyAssignment b959d571-f0b5-4042-88a7-01be6cb22db9_a1705bd2-3a8f-45a5-8683-466fcfd5cc24 /{scope}/providers/Microsoft.Authorization/roleManagementPolicyAssignments/{roleManagementPolicyAssignmentName}
 * ```
 * @property policyId The policy id role management policy assignment.
 * @property roleDefinitionId The role definition of management policy assignment.
 * @property roleManagementPolicyAssignmentName The name of format {guid_guid} the role management policy assignment to upsert.
 * @property scope The role management policy scope.
 */
public data class RoleManagementPolicyAssignmentArgs(
    public val policyId: Output<String>? = null,
    public val roleDefinitionId: Output<String>? = null,
    public val roleManagementPolicyAssignmentName: Output<String>? = null,
    public val scope: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.authorization.RoleManagementPolicyAssignmentArgs> {
    override fun toJava(): com.pulumi.azurenative.authorization.RoleManagementPolicyAssignmentArgs =
        com.pulumi.azurenative.authorization.RoleManagementPolicyAssignmentArgs.builder()
            .policyId(policyId?.applyValue({ args0 -> args0 }))
            .roleDefinitionId(roleDefinitionId?.applyValue({ args0 -> args0 }))
            .roleManagementPolicyAssignmentName(
                roleManagementPolicyAssignmentName?.applyValue({ args0 ->
                    args0
                }),
            )
            .scope(scope?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [RoleManagementPolicyAssignmentArgs].
 */
@PulumiTagMarker
public class RoleManagementPolicyAssignmentArgsBuilder internal constructor() {
    private var policyId: Output<String>? = null

    private var roleDefinitionId: Output<String>? = null

    private var roleManagementPolicyAssignmentName: Output<String>? = null

    private var scope: Output<String>? = null

    /**
     * @param value The policy id role management policy assignment.
     */
    @JvmName("mnifhaxksafxhqte")
    public suspend fun policyId(`value`: Output<String>) {
        this.policyId = value
    }

    /**
     * @param value The role definition of management policy assignment.
     */
    @JvmName("gynvffhihfkplhhg")
    public suspend fun roleDefinitionId(`value`: Output<String>) {
        this.roleDefinitionId = value
    }

    /**
     * @param value The name of format {guid_guid} the role management policy assignment to upsert.
     */
    @JvmName("qcrycepwbtpffaty")
    public suspend fun roleManagementPolicyAssignmentName(`value`: Output<String>) {
        this.roleManagementPolicyAssignmentName = value
    }

    /**
     * @param value The role management policy scope.
     */
    @JvmName("tfuyxxbvffjjhdwm")
    public suspend fun scope(`value`: Output<String>) {
        this.scope = value
    }

    /**
     * @param value The policy id role management policy assignment.
     */
    @JvmName("kqbhsvhirkprgfmb")
    public suspend fun policyId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.policyId = mapped
    }

    /**
     * @param value The role definition of management policy assignment.
     */
    @JvmName("utwvtqcfagxwqpsp")
    public suspend fun roleDefinitionId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.roleDefinitionId = mapped
    }

    /**
     * @param value The name of format {guid_guid} the role management policy assignment to upsert.
     */
    @JvmName("qttfhnhdrqxvgedn")
    public suspend fun roleManagementPolicyAssignmentName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.roleManagementPolicyAssignmentName = mapped
    }

    /**
     * @param value The role management policy scope.
     */
    @JvmName("sgyqlxxpmtifsxpb")
    public suspend fun scope(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.scope = mapped
    }

    internal fun build(): RoleManagementPolicyAssignmentArgs = RoleManagementPolicyAssignmentArgs(
        policyId = policyId,
        roleDefinitionId = roleDefinitionId,
        roleManagementPolicyAssignmentName = roleManagementPolicyAssignmentName,
        scope = scope,
    )
}
