@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.authorization.kotlin.inputs

import com.pulumi.azurenative.authorization.inputs.AccessReviewInstanceArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Access Review Instance.
 * @property backupReviewers This is the collection of backup reviewers.
 * @property endDateTime The DateTime when the review instance is scheduled to end.
 * @property reviewers This is the collection of reviewers.
 * @property startDateTime The DateTime when the review instance is scheduled to be start.
 */
public data class AccessReviewInstanceArgs(
    public val backupReviewers: Output<List<AccessReviewReviewerArgs>>? = null,
    public val endDateTime: Output<String>? = null,
    public val reviewers: Output<List<AccessReviewReviewerArgs>>? = null,
    public val startDateTime: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.authorization.inputs.AccessReviewInstanceArgs> {
    override fun toJava(): com.pulumi.azurenative.authorization.inputs.AccessReviewInstanceArgs =
        com.pulumi.azurenative.authorization.inputs.AccessReviewInstanceArgs.builder()
            .backupReviewers(
                backupReviewers?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .endDateTime(endDateTime?.applyValue({ args0 -> args0 }))
            .reviewers(
                reviewers?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .startDateTime(startDateTime?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AccessReviewInstanceArgs].
 */
@PulumiTagMarker
public class AccessReviewInstanceArgsBuilder internal constructor() {
    private var backupReviewers: Output<List<AccessReviewReviewerArgs>>? = null

    private var endDateTime: Output<String>? = null

    private var reviewers: Output<List<AccessReviewReviewerArgs>>? = null

    private var startDateTime: Output<String>? = null

    /**
     * @param value This is the collection of backup reviewers.
     */
    @JvmName("binikbmchvcgpuoa")
    public suspend fun backupReviewers(`value`: Output<List<AccessReviewReviewerArgs>>) {
        this.backupReviewers = value
    }

    @JvmName("wkbielbejbllkpya")
    public suspend fun backupReviewers(vararg values: Output<AccessReviewReviewerArgs>) {
        this.backupReviewers = Output.all(values.asList())
    }

    /**
     * @param values This is the collection of backup reviewers.
     */
    @JvmName("mpxmhhuckkgbhpri")
    public suspend fun backupReviewers(values: List<Output<AccessReviewReviewerArgs>>) {
        this.backupReviewers = Output.all(values)
    }

    /**
     * @param value The DateTime when the review instance is scheduled to end.
     */
    @JvmName("ckjrbuxwcwfufhss")
    public suspend fun endDateTime(`value`: Output<String>) {
        this.endDateTime = value
    }

    /**
     * @param value This is the collection of reviewers.
     */
    @JvmName("qvimftuxqruomekd")
    public suspend fun reviewers(`value`: Output<List<AccessReviewReviewerArgs>>) {
        this.reviewers = value
    }

    @JvmName("gjseemtapmyuqicv")
    public suspend fun reviewers(vararg values: Output<AccessReviewReviewerArgs>) {
        this.reviewers = Output.all(values.asList())
    }

    /**
     * @param values This is the collection of reviewers.
     */
    @JvmName("bcahewhewomrjwjo")
    public suspend fun reviewers(values: List<Output<AccessReviewReviewerArgs>>) {
        this.reviewers = Output.all(values)
    }

    /**
     * @param value The DateTime when the review instance is scheduled to be start.
     */
    @JvmName("qlwdtkcpccmcrofu")
    public suspend fun startDateTime(`value`: Output<String>) {
        this.startDateTime = value
    }

    /**
     * @param value This is the collection of backup reviewers.
     */
    @JvmName("khltuqcstoqedwlq")
    public suspend fun backupReviewers(`value`: List<AccessReviewReviewerArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.backupReviewers = mapped
    }

    /**
     * @param argument This is the collection of backup reviewers.
     */
    @JvmName("aogpbpwxgdlyyfxd")
    public suspend
    fun backupReviewers(argument: List<suspend AccessReviewReviewerArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            AccessReviewReviewerArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.backupReviewers = mapped
    }

    /**
     * @param argument This is the collection of backup reviewers.
     */
    @JvmName("gqbwjkdppgdeqwlb")
    public suspend fun backupReviewers(
        vararg
        argument: suspend AccessReviewReviewerArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            AccessReviewReviewerArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.backupReviewers = mapped
    }

    /**
     * @param argument This is the collection of backup reviewers.
     */
    @JvmName("jdkyhephwgwklmmr")
    public suspend fun backupReviewers(argument: suspend AccessReviewReviewerArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(AccessReviewReviewerArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.backupReviewers = mapped
    }

    /**
     * @param values This is the collection of backup reviewers.
     */
    @JvmName("qjqfbosvdkrrpoxj")
    public suspend fun backupReviewers(vararg values: AccessReviewReviewerArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.backupReviewers = mapped
    }

    /**
     * @param value The DateTime when the review instance is scheduled to end.
     */
    @JvmName("ujgcncbqvyohexoh")
    public suspend fun endDateTime(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.endDateTime = mapped
    }

    /**
     * @param value This is the collection of reviewers.
     */
    @JvmName("hbgxivaifiamebly")
    public suspend fun reviewers(`value`: List<AccessReviewReviewerArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.reviewers = mapped
    }

    /**
     * @param argument This is the collection of reviewers.
     */
    @JvmName("edkucatibvwhpxie")
    public suspend fun reviewers(argument: List<suspend AccessReviewReviewerArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            AccessReviewReviewerArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.reviewers = mapped
    }

    /**
     * @param argument This is the collection of reviewers.
     */
    @JvmName("qoeyispnhsfcdoqk")
    public suspend fun reviewers(
        vararg
        argument: suspend AccessReviewReviewerArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            AccessReviewReviewerArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.reviewers = mapped
    }

    /**
     * @param argument This is the collection of reviewers.
     */
    @JvmName("kutfjlchnybngsei")
    public suspend fun reviewers(argument: suspend AccessReviewReviewerArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(AccessReviewReviewerArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.reviewers = mapped
    }

    /**
     * @param values This is the collection of reviewers.
     */
    @JvmName("nvywnkljcxmlmayj")
    public suspend fun reviewers(vararg values: AccessReviewReviewerArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.reviewers = mapped
    }

    /**
     * @param value The DateTime when the review instance is scheduled to be start.
     */
    @JvmName("nbrrbuvrhmueiocm")
    public suspend fun startDateTime(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.startDateTime = mapped
    }

    internal fun build(): AccessReviewInstanceArgs = AccessReviewInstanceArgs(
        backupReviewers = backupReviewers,
        endDateTime = endDateTime,
        reviewers = reviewers,
        startDateTime = startDateTime,
    )
}
