@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.authorization.kotlin.inputs

import com.pulumi.azurenative.authorization.inputs.GetPolicyAssignmentPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property policyAssignmentName The name of the policy assignment to get.
 * @property scope The scope of the policy assignment. Valid scopes are: management group (format: '/providers/Microsoft.Management/managementGroups/{managementGroup}'), subscription (format: '/subscriptions/{subscriptionId}'), resource group (format: '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}', or resource (format: '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/[{parentResourcePath}/]{resourceType}/{resourceName}'
 */
public data class GetPolicyAssignmentPlainArgs(
    public val policyAssignmentName: String,
    public val scope: String,
) : ConvertibleToJava<com.pulumi.azurenative.authorization.inputs.GetPolicyAssignmentPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.authorization.inputs.GetPolicyAssignmentPlainArgs =
        com.pulumi.azurenative.authorization.inputs.GetPolicyAssignmentPlainArgs.builder()
            .policyAssignmentName(policyAssignmentName.let({ args0 -> args0 }))
            .scope(scope.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetPolicyAssignmentPlainArgs].
 */
@PulumiTagMarker
public class GetPolicyAssignmentPlainArgsBuilder internal constructor() {
    private var policyAssignmentName: String? = null

    private var scope: String? = null

    /**
     * @param value The name of the policy assignment to get.
     */
    @JvmName("picpybarbhcohwph")
    public suspend fun policyAssignmentName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.policyAssignmentName = mapped
    }

    /**
     * @param value The scope of the policy assignment. Valid scopes are: management group (format: '/providers/Microsoft.Management/managementGroups/{managementGroup}'), subscription (format: '/subscriptions/{subscriptionId}'), resource group (format: '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}', or resource (format: '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/[{parentResourcePath}/]{resourceType}/{resourceName}'
     */
    @JvmName("lbxabrgsneutlydl")
    public suspend fun scope(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.scope = mapped
    }

    internal fun build(): GetPolicyAssignmentPlainArgs = GetPolicyAssignmentPlainArgs(
        policyAssignmentName = policyAssignmentName ?: throw
            PulumiNullFieldException("policyAssignmentName"),
        scope = scope ?: throw PulumiNullFieldException("scope"),
    )
}
