@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.authorization.kotlin.inputs

import com.pulumi.azurenative.authorization.inputs.GetScopeAccessReviewScheduleDefinitionByIdPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property scheduleDefinitionId The id of the access review schedule definition.
 * @property scope The scope of the resource.
 */
public data class GetScopeAccessReviewScheduleDefinitionByIdPlainArgs(
    public val scheduleDefinitionId: String,
    public val scope: String,
) :
    ConvertibleToJava<com.pulumi.azurenative.authorization.inputs.GetScopeAccessReviewScheduleDefinitionByIdPlainArgs> {
    override fun toJava():
        com.pulumi.azurenative.authorization.inputs.GetScopeAccessReviewScheduleDefinitionByIdPlainArgs =
        com.pulumi.azurenative.authorization.inputs.GetScopeAccessReviewScheduleDefinitionByIdPlainArgs.builder()
            .scheduleDefinitionId(scheduleDefinitionId.let({ args0 -> args0 }))
            .scope(scope.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetScopeAccessReviewScheduleDefinitionByIdPlainArgs].
 */
@PulumiTagMarker
public class GetScopeAccessReviewScheduleDefinitionByIdPlainArgsBuilder internal constructor() {
    private var scheduleDefinitionId: String? = null

    private var scope: String? = null

    /**
     * @param value The id of the access review schedule definition.
     */
    @JvmName("reuiyvhxxrrnjukd")
    public suspend fun scheduleDefinitionId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.scheduleDefinitionId = mapped
    }

    /**
     * @param value The scope of the resource.
     */
    @JvmName("vexocljktpsloypw")
    public suspend fun scope(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.scope = mapped
    }

    internal fun build(): GetScopeAccessReviewScheduleDefinitionByIdPlainArgs =
        GetScopeAccessReviewScheduleDefinitionByIdPlainArgs(
            scheduleDefinitionId = scheduleDefinitionId ?: throw
                PulumiNullFieldException("scheduleDefinitionId"),
            scope = scope ?: throw PulumiNullFieldException("scope"),
        )
}
