@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.authorization.kotlin.inputs

import com.pulumi.azurenative.authorization.inputs.GetVariablePlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property variableName The name of the variable to operate on.
 */
public data class GetVariablePlainArgs(
    public val variableName: String,
) : ConvertibleToJava<com.pulumi.azurenative.authorization.inputs.GetVariablePlainArgs> {
    override fun toJava(): com.pulumi.azurenative.authorization.inputs.GetVariablePlainArgs =
        com.pulumi.azurenative.authorization.inputs.GetVariablePlainArgs.builder()
            .variableName(variableName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetVariablePlainArgs].
 */
@PulumiTagMarker
public class GetVariablePlainArgsBuilder internal constructor() {
    private var variableName: String? = null

    /**
     * @param value The name of the variable to operate on.
     */
    @JvmName("qmueqlfgricrtegs")
    public suspend fun variableName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.variableName = mapped
    }

    internal fun build(): GetVariablePlainArgs = GetVariablePlainArgs(
        variableName = variableName ?: throw PulumiNullFieldException("variableName"),
    )
}
