@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.authorization.kotlin.inputs

import com.pulumi.azurenative.authorization.inputs.ListPolicySetDefinitionVersionAllAtManagementGroupPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property managementGroupName The name of the management group. The name is case insensitive.
 */
public data class ListPolicySetDefinitionVersionAllAtManagementGroupPlainArgs(
    public val managementGroupName: String,
) :
    ConvertibleToJava<com.pulumi.azurenative.authorization.inputs.ListPolicySetDefinitionVersionAllAtManagementGroupPlainArgs> {
    override fun toJava():
        com.pulumi.azurenative.authorization.inputs.ListPolicySetDefinitionVersionAllAtManagementGroupPlainArgs =
        com.pulumi.azurenative.authorization.inputs.ListPolicySetDefinitionVersionAllAtManagementGroupPlainArgs.builder()
            .managementGroupName(managementGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [ListPolicySetDefinitionVersionAllAtManagementGroupPlainArgs].
 */
@PulumiTagMarker
public class ListPolicySetDefinitionVersionAllAtManagementGroupPlainArgsBuilder internal
constructor() {
    private var managementGroupName: String? = null

    /**
     * @param value The name of the management group. The name is case insensitive.
     */
    @JvmName("sddttycombhnwngg")
    public suspend fun managementGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.managementGroupName = mapped
    }

    internal fun build(): ListPolicySetDefinitionVersionAllAtManagementGroupPlainArgs =
        ListPolicySetDefinitionVersionAllAtManagementGroupPlainArgs(
            managementGroupName = managementGroupName ?: throw PulumiNullFieldException("managementGroupName"),
        )
}
