@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.authorization.kotlin.inputs

import com.pulumi.azurenative.authorization.inputs.ManagementLockOwnerArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Lock owner properties.
 * @property applicationId The application ID of the lock owner.
 */
public data class ManagementLockOwnerArgs(
    public val applicationId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.authorization.inputs.ManagementLockOwnerArgs> {
    override fun toJava(): com.pulumi.azurenative.authorization.inputs.ManagementLockOwnerArgs =
        com.pulumi.azurenative.authorization.inputs.ManagementLockOwnerArgs.builder()
            .applicationId(applicationId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ManagementLockOwnerArgs].
 */
@PulumiTagMarker
public class ManagementLockOwnerArgsBuilder internal constructor() {
    private var applicationId: Output<String>? = null

    /**
     * @param value The application ID of the lock owner.
     */
    @JvmName("vapkrrjxfyqlnaqp")
    public suspend fun applicationId(`value`: Output<String>) {
        this.applicationId = value
    }

    /**
     * @param value The application ID of the lock owner.
     */
    @JvmName("osbfhbkinjtwhkit")
    public suspend fun applicationId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.applicationId = mapped
    }

    internal fun build(): ManagementLockOwnerArgs = ManagementLockOwnerArgs(
        applicationId = applicationId,
    )
}
