@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.authorization.kotlin.inputs

import com.pulumi.azurenative.authorization.inputs.NonComplianceMessageArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A message that describes why a resource is non-compliant with the policy. This is shown in 'deny' error messages and on resource's non-compliant compliance results.
 * @property message A message that describes why a resource is non-compliant with the policy. This is shown in 'deny' error messages and on resource's non-compliant compliance results.
 * @property policyDefinitionReferenceId The policy definition reference ID within a policy set definition the message is intended for. This is only applicable if the policy assignment assigns a policy set definition. If this is not provided the message applies to all policies assigned by this policy assignment.
 */
public data class NonComplianceMessageArgs(
    public val message: Output<String>,
    public val policyDefinitionReferenceId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.authorization.inputs.NonComplianceMessageArgs> {
    override fun toJava(): com.pulumi.azurenative.authorization.inputs.NonComplianceMessageArgs =
        com.pulumi.azurenative.authorization.inputs.NonComplianceMessageArgs.builder()
            .message(message.applyValue({ args0 -> args0 }))
            .policyDefinitionReferenceId(policyDefinitionReferenceId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [NonComplianceMessageArgs].
 */
@PulumiTagMarker
public class NonComplianceMessageArgsBuilder internal constructor() {
    private var message: Output<String>? = null

    private var policyDefinitionReferenceId: Output<String>? = null

    /**
     * @param value A message that describes why a resource is non-compliant with the policy. This is shown in 'deny' error messages and on resource's non-compliant compliance results.
     */
    @JvmName("pfyrhkqvwllnjbvb")
    public suspend fun message(`value`: Output<String>) {
        this.message = value
    }

    /**
     * @param value The policy definition reference ID within a policy set definition the message is intended for. This is only applicable if the policy assignment assigns a policy set definition. If this is not provided the message applies to all policies assigned by this policy assignment.
     */
    @JvmName("lfmnerabydunmfwu")
    public suspend fun policyDefinitionReferenceId(`value`: Output<String>) {
        this.policyDefinitionReferenceId = value
    }

    /**
     * @param value A message that describes why a resource is non-compliant with the policy. This is shown in 'deny' error messages and on resource's non-compliant compliance results.
     */
    @JvmName("yjiahwnxsunkftgp")
    public suspend fun message(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.message = mapped
    }

    /**
     * @param value The policy definition reference ID within a policy set definition the message is intended for. This is only applicable if the policy assignment assigns a policy set definition. If this is not provided the message applies to all policies assigned by this policy assignment.
     */
    @JvmName("ymkdeqeunwfsrdef")
    public suspend fun policyDefinitionReferenceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.policyDefinitionReferenceId = mapped
    }

    internal fun build(): NonComplianceMessageArgs = NonComplianceMessageArgs(
        message = message ?: throw PulumiNullFieldException("message"),
        policyDefinitionReferenceId = policyDefinitionReferenceId,
    )
}
