@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.authorization.kotlin.inputs

import com.pulumi.azurenative.authorization.inputs.OverrideArgs.builder
import com.pulumi.azurenative.authorization.kotlin.enums.OverrideKind
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * The policy property value override.
 * @property kind The override kind.
 * @property selectors The list of the selector expressions.
 * @property value The value to override the policy property.
 */
public data class OverrideArgs(
    public val kind: Output<Either<String, OverrideKind>>? = null,
    public val selectors: Output<List<SelectorArgs>>? = null,
    public val `value`: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.authorization.inputs.OverrideArgs> {
    override fun toJava(): com.pulumi.azurenative.authorization.inputs.OverrideArgs =
        com.pulumi.azurenative.authorization.inputs.OverrideArgs.builder()
            .kind(
                kind?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .selectors(
                selectors?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .`value`(`value`?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [OverrideArgs].
 */
@PulumiTagMarker
public class OverrideArgsBuilder internal constructor() {
    private var kind: Output<Either<String, OverrideKind>>? = null

    private var selectors: Output<List<SelectorArgs>>? = null

    private var `value`: Output<String>? = null

    /**
     * @param value The override kind.
     */
    @JvmName("pgncchhtiysctqii")
    public suspend fun kind(`value`: Output<Either<String, OverrideKind>>) {
        this.kind = value
    }

    /**
     * @param value The list of the selector expressions.
     */
    @JvmName("iiqbenktqsgavniy")
    public suspend fun selectors(`value`: Output<List<SelectorArgs>>) {
        this.selectors = value
    }

    @JvmName("eshglqqtsjkfagem")
    public suspend fun selectors(vararg values: Output<SelectorArgs>) {
        this.selectors = Output.all(values.asList())
    }

    /**
     * @param values The list of the selector expressions.
     */
    @JvmName("coysjndiubrfaoqw")
    public suspend fun selectors(values: List<Output<SelectorArgs>>) {
        this.selectors = Output.all(values)
    }

    /**
     * @param value The value to override the policy property.
     */
    @JvmName("bedgtxsrdobktcwm")
    public suspend fun `value`(`value`: Output<String>) {
        this.`value` = value
    }

    /**
     * @param value The override kind.
     */
    @JvmName("bpiufuwgkwjagwcs")
    public suspend fun kind(`value`: Either<String, OverrideKind>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kind = mapped
    }

    /**
     * @param value The override kind.
     */
    @JvmName("taiyyvjrbekgmebh")
    public fun kind(`value`: String) {
        val toBeMapped = Either.ofLeft<String, OverrideKind>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.kind = mapped
    }

    /**
     * @param value The override kind.
     */
    @JvmName("rcybtbibytxajtnx")
    public fun kind(`value`: OverrideKind) {
        val toBeMapped = Either.ofRight<String, OverrideKind>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.kind = mapped
    }

    /**
     * @param value The list of the selector expressions.
     */
    @JvmName("ldddmfacfnfqrgpw")
    public suspend fun selectors(`value`: List<SelectorArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.selectors = mapped
    }

    /**
     * @param argument The list of the selector expressions.
     */
    @JvmName("fsygheqcjmvqcvps")
    public suspend fun selectors(argument: List<suspend SelectorArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map { SelectorArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.selectors = mapped
    }

    /**
     * @param argument The list of the selector expressions.
     */
    @JvmName("uclobjgtpkgrylga")
    public suspend fun selectors(vararg argument: suspend SelectorArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map { SelectorArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.selectors = mapped
    }

    /**
     * @param argument The list of the selector expressions.
     */
    @JvmName("hblamjanfnvalfbh")
    public suspend fun selectors(argument: suspend SelectorArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(SelectorArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.selectors = mapped
    }

    /**
     * @param values The list of the selector expressions.
     */
    @JvmName("nbdtescshlrhowov")
    public suspend fun selectors(vararg values: SelectorArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.selectors = mapped
    }

    /**
     * @param value The value to override the policy property.
     */
    @JvmName("fxffigridrdmqtmh")
    public suspend fun `value`(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.`value` = mapped
    }

    internal fun build(): OverrideArgs = OverrideArgs(
        kind = kind,
        selectors = selectors,
        `value` = `value`,
    )
}
