@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.authorization.kotlin.inputs

import com.pulumi.azurenative.authorization.inputs.ParameterDefinitionsValueArgs.builder
import com.pulumi.azurenative.authorization.kotlin.enums.ParameterType
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Any
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * The definition of a parameter that can be provided to the policy.
 * @property allowedValues The allowed values for the parameter.
 * @property defaultValue The default value for the parameter if no value is provided.
 * @property metadata General metadata for the parameter.
 * @property schema Provides validation of parameter inputs during assignment using a self-defined JSON schema. This property is only supported for object-type parameters and follows the Json.NET Schema 2019-09 implementation. You can learn more about using schemas at https://json-schema.org/ and test draft schemas at https://www.jsonschemavalidator.net/.
 * @property type The data type of the parameter.
 */
public data class ParameterDefinitionsValueArgs(
    public val allowedValues: Output<List<Any>>? = null,
    public val defaultValue: Output<Any>? = null,
    public val metadata: Output<ParameterDefinitionsValueMetadataArgs>? = null,
    public val schema: Output<Any>? = null,
    public val type: Output<Either<String, ParameterType>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.authorization.inputs.ParameterDefinitionsValueArgs> {
    override fun toJava(): com.pulumi.azurenative.authorization.inputs.ParameterDefinitionsValueArgs =
        com.pulumi.azurenative.authorization.inputs.ParameterDefinitionsValueArgs.builder()
            .allowedValues(allowedValues?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .defaultValue(defaultValue?.applyValue({ args0 -> args0 }))
            .metadata(metadata?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .schema(schema?.applyValue({ args0 -> args0 }))
            .type(
                type?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [ParameterDefinitionsValueArgs].
 */
@PulumiTagMarker
public class ParameterDefinitionsValueArgsBuilder internal constructor() {
    private var allowedValues: Output<List<Any>>? = null

    private var defaultValue: Output<Any>? = null

    private var metadata: Output<ParameterDefinitionsValueMetadataArgs>? = null

    private var schema: Output<Any>? = null

    private var type: Output<Either<String, ParameterType>>? = null

    /**
     * @param value The allowed values for the parameter.
     */
    @JvmName("tmvqwyrwbfunyrkq")
    public suspend fun allowedValues(`value`: Output<List<Any>>) {
        this.allowedValues = value
    }

    @JvmName("fttxflehclxhciog")
    public suspend fun allowedValues(vararg values: Output<Any>) {
        this.allowedValues = Output.all(values.asList())
    }

    /**
     * @param values The allowed values for the parameter.
     */
    @JvmName("eyrlpptoyivanbvh")
    public suspend fun allowedValues(values: List<Output<Any>>) {
        this.allowedValues = Output.all(values)
    }

    /**
     * @param value The default value for the parameter if no value is provided.
     */
    @JvmName("empsfxrsyhlqqfyj")
    public suspend fun defaultValue(`value`: Output<Any>) {
        this.defaultValue = value
    }

    /**
     * @param value General metadata for the parameter.
     */
    @JvmName("aqstomepvhemthjh")
    public suspend fun metadata(`value`: Output<ParameterDefinitionsValueMetadataArgs>) {
        this.metadata = value
    }

    /**
     * @param value Provides validation of parameter inputs during assignment using a self-defined JSON schema. This property is only supported for object-type parameters and follows the Json.NET Schema 2019-09 implementation. You can learn more about using schemas at https://json-schema.org/ and test draft schemas at https://www.jsonschemavalidator.net/.
     */
    @JvmName("iajppmmtdxaqyaap")
    public suspend fun schema(`value`: Output<Any>) {
        this.schema = value
    }

    /**
     * @param value The data type of the parameter.
     */
    @JvmName("owmuaxnunvpognok")
    public suspend fun type(`value`: Output<Either<String, ParameterType>>) {
        this.type = value
    }

    /**
     * @param value The allowed values for the parameter.
     */
    @JvmName("klxcuycarmonaqub")
    public suspend fun allowedValues(`value`: List<Any>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.allowedValues = mapped
    }

    /**
     * @param values The allowed values for the parameter.
     */
    @JvmName("cdniuavfhchgjfop")
    public suspend fun allowedValues(vararg values: Any) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.allowedValues = mapped
    }

    /**
     * @param value The default value for the parameter if no value is provided.
     */
    @JvmName("wyxxxpumohntfhyo")
    public suspend fun defaultValue(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.defaultValue = mapped
    }

    /**
     * @param value General metadata for the parameter.
     */
    @JvmName("ihsjbxiyrgcmnaaf")
    public suspend fun metadata(`value`: ParameterDefinitionsValueMetadataArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.metadata = mapped
    }

    /**
     * @param argument General metadata for the parameter.
     */
    @JvmName("cahenhbvxhnjpxru")
    public suspend
    fun metadata(argument: suspend ParameterDefinitionsValueMetadataArgsBuilder.() -> Unit) {
        val toBeMapped = ParameterDefinitionsValueMetadataArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.metadata = mapped
    }

    /**
     * @param value Provides validation of parameter inputs during assignment using a self-defined JSON schema. This property is only supported for object-type parameters and follows the Json.NET Schema 2019-09 implementation. You can learn more about using schemas at https://json-schema.org/ and test draft schemas at https://www.jsonschemavalidator.net/.
     */
    @JvmName("mehcbijoobfqjgvv")
    public suspend fun schema(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.schema = mapped
    }

    /**
     * @param value The data type of the parameter.
     */
    @JvmName("hqgavgoerjojqmqi")
    public suspend fun type(`value`: Either<String, ParameterType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value The data type of the parameter.
     */
    @JvmName("likdwivplbysdjxj")
    public fun type(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ParameterType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value The data type of the parameter.
     */
    @JvmName("bhhrdvwdceugegjr")
    public fun type(`value`: ParameterType) {
        val toBeMapped = Either.ofRight<String, ParameterType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): ParameterDefinitionsValueArgs = ParameterDefinitionsValueArgs(
        allowedValues = allowedValues,
        defaultValue = defaultValue,
        metadata = metadata,
        schema = schema,
        type = type,
    )
}
