@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.authorization.kotlin.inputs

import com.pulumi.azurenative.authorization.inputs.PolicyDefinitionGroupArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The policy definition group.
 * @property additionalMetadataId A resource ID of a resource that contains additional metadata about the group.
 * @property category The group's category.
 * @property description The group's description.
 * @property displayName The group's display name.
 * @property name The name of the group.
 */
public data class PolicyDefinitionGroupArgs(
    public val additionalMetadataId: Output<String>? = null,
    public val category: Output<String>? = null,
    public val description: Output<String>? = null,
    public val displayName: Output<String>? = null,
    public val name: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.authorization.inputs.PolicyDefinitionGroupArgs> {
    override fun toJava(): com.pulumi.azurenative.authorization.inputs.PolicyDefinitionGroupArgs =
        com.pulumi.azurenative.authorization.inputs.PolicyDefinitionGroupArgs.builder()
            .additionalMetadataId(additionalMetadataId?.applyValue({ args0 -> args0 }))
            .category(category?.applyValue({ args0 -> args0 }))
            .description(description?.applyValue({ args0 -> args0 }))
            .displayName(displayName?.applyValue({ args0 -> args0 }))
            .name(name.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [PolicyDefinitionGroupArgs].
 */
@PulumiTagMarker
public class PolicyDefinitionGroupArgsBuilder internal constructor() {
    private var additionalMetadataId: Output<String>? = null

    private var category: Output<String>? = null

    private var description: Output<String>? = null

    private var displayName: Output<String>? = null

    private var name: Output<String>? = null

    /**
     * @param value A resource ID of a resource that contains additional metadata about the group.
     */
    @JvmName("stdlfeemeepdoxwg")
    public suspend fun additionalMetadataId(`value`: Output<String>) {
        this.additionalMetadataId = value
    }

    /**
     * @param value The group's category.
     */
    @JvmName("ilcctjsuxbujvlkw")
    public suspend fun category(`value`: Output<String>) {
        this.category = value
    }

    /**
     * @param value The group's description.
     */
    @JvmName("mfmtppquibybwbbi")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value The group's display name.
     */
    @JvmName("pqdrdgopycntlmvq")
    public suspend fun displayName(`value`: Output<String>) {
        this.displayName = value
    }

    /**
     * @param value The name of the group.
     */
    @JvmName("ikwgypapiqmnvyaf")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value A resource ID of a resource that contains additional metadata about the group.
     */
    @JvmName("diywbtnpnekjvgam")
    public suspend fun additionalMetadataId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.additionalMetadataId = mapped
    }

    /**
     * @param value The group's category.
     */
    @JvmName("lkdravldmdbrpeox")
    public suspend fun category(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.category = mapped
    }

    /**
     * @param value The group's description.
     */
    @JvmName("lplhbqkdxjqxxlbn")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value The group's display name.
     */
    @JvmName("hfhnxplgyrnreumm")
    public suspend fun displayName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.displayName = mapped
    }

    /**
     * @param value The name of the group.
     */
    @JvmName("idxqxadtmpbadqjk")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    internal fun build(): PolicyDefinitionGroupArgs = PolicyDefinitionGroupArgs(
        additionalMetadataId = additionalMetadataId,
        category = category,
        description = description,
        displayName = displayName,
        name = name ?: throw PulumiNullFieldException("name"),
    )
}
