@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.authorization.kotlin.inputs

import com.pulumi.azurenative.authorization.inputs.ResourceSelectorArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * The resource selector to filter policies by resource properties.
 * @property name The name of the resource selector.
 * @property selectors The list of the selector expressions.
 */
public data class ResourceSelectorArgs(
    public val name: Output<String>? = null,
    public val selectors: Output<List<SelectorArgs>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.authorization.inputs.ResourceSelectorArgs> {
    override fun toJava(): com.pulumi.azurenative.authorization.inputs.ResourceSelectorArgs =
        com.pulumi.azurenative.authorization.inputs.ResourceSelectorArgs.builder()
            .name(name?.applyValue({ args0 -> args0 }))
            .selectors(
                selectors?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [ResourceSelectorArgs].
 */
@PulumiTagMarker
public class ResourceSelectorArgsBuilder internal constructor() {
    private var name: Output<String>? = null

    private var selectors: Output<List<SelectorArgs>>? = null

    /**
     * @param value The name of the resource selector.
     */
    @JvmName("bjnjcgiqmyonbefr")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The list of the selector expressions.
     */
    @JvmName("iosrvcfbjvcupmqd")
    public suspend fun selectors(`value`: Output<List<SelectorArgs>>) {
        this.selectors = value
    }

    @JvmName("ssdqnlyiokrusapt")
    public suspend fun selectors(vararg values: Output<SelectorArgs>) {
        this.selectors = Output.all(values.asList())
    }

    /**
     * @param values The list of the selector expressions.
     */
    @JvmName("hmnfbdqxajidqmpj")
    public suspend fun selectors(values: List<Output<SelectorArgs>>) {
        this.selectors = Output.all(values)
    }

    /**
     * @param value The name of the resource selector.
     */
    @JvmName("ovdewbtxxwpdyoee")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The list of the selector expressions.
     */
    @JvmName("lwmlxoruuttftshi")
    public suspend fun selectors(`value`: List<SelectorArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.selectors = mapped
    }

    /**
     * @param argument The list of the selector expressions.
     */
    @JvmName("kifyojwgnctwbsmd")
    public suspend fun selectors(argument: List<suspend SelectorArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map { SelectorArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.selectors = mapped
    }

    /**
     * @param argument The list of the selector expressions.
     */
    @JvmName("ukccgiqqnhnfucmf")
    public suspend fun selectors(vararg argument: suspend SelectorArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map { SelectorArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.selectors = mapped
    }

    /**
     * @param argument The list of the selector expressions.
     */
    @JvmName("lynpoisojrslfnvp")
    public suspend fun selectors(argument: suspend SelectorArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(SelectorArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.selectors = mapped
    }

    /**
     * @param values The list of the selector expressions.
     */
    @JvmName("krwgobuclakokwlu")
    public suspend fun selectors(vararg values: SelectorArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.selectors = mapped
    }

    internal fun build(): ResourceSelectorArgs = ResourceSelectorArgs(
        name = name,
        selectors = selectors,
    )
}
