@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.authorization.kotlin.inputs

import com.pulumi.azurenative.authorization.inputs.SelectorArgs.builder
import com.pulumi.azurenative.authorization.kotlin.enums.SelectorKind
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * The selector expression.
 * @property in The list of values to filter in.
 * @property kind The selector kind.
 * @property notIn The list of values to filter out.
 */
public data class SelectorArgs(
    public val `in`: Output<List<String>>? = null,
    public val kind: Output<Either<String, SelectorKind>>? = null,
    public val notIn: Output<List<String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.authorization.inputs.SelectorArgs> {
    override fun toJava(): com.pulumi.azurenative.authorization.inputs.SelectorArgs =
        com.pulumi.azurenative.authorization.inputs.SelectorArgs.builder()
            .`in`(`in`?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .kind(
                kind?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .notIn(notIn?.applyValue({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [SelectorArgs].
 */
@PulumiTagMarker
public class SelectorArgsBuilder internal constructor() {
    private var `in`: Output<List<String>>? = null

    private var kind: Output<Either<String, SelectorKind>>? = null

    private var notIn: Output<List<String>>? = null

    /**
     * @param value The list of values to filter in.
     */
    @JvmName("ksinkvlqpnxrnpbe")
    public suspend fun `in`(`value`: Output<List<String>>) {
        this.`in` = value
    }

    @JvmName("jnpkfgpxrrdfjmll")
    public suspend fun `in`(vararg values: Output<String>) {
        this.`in` = Output.all(values.asList())
    }

    /**
     * @param values The list of values to filter in.
     */
    @JvmName("dmisetsaqitnmtrq")
    public suspend fun `in`(values: List<Output<String>>) {
        this.`in` = Output.all(values)
    }

    /**
     * @param value The selector kind.
     */
    @JvmName("tdophjlkordgoqai")
    public suspend fun kind(`value`: Output<Either<String, SelectorKind>>) {
        this.kind = value
    }

    /**
     * @param value The list of values to filter out.
     */
    @JvmName("dqcmpqskwrvqsvhv")
    public suspend fun notIn(`value`: Output<List<String>>) {
        this.notIn = value
    }

    @JvmName("eiqfgnplabswwehn")
    public suspend fun notIn(vararg values: Output<String>) {
        this.notIn = Output.all(values.asList())
    }

    /**
     * @param values The list of values to filter out.
     */
    @JvmName("ajeprtudkcwlkbyi")
    public suspend fun notIn(values: List<Output<String>>) {
        this.notIn = Output.all(values)
    }

    /**
     * @param value The list of values to filter in.
     */
    @JvmName("biqajhagoaqlxaey")
    public suspend fun `in`(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.`in` = mapped
    }

    /**
     * @param values The list of values to filter in.
     */
    @JvmName("ansdyfgdhtwgfvnm")
    public suspend fun `in`(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.`in` = mapped
    }

    /**
     * @param value The selector kind.
     */
    @JvmName("slnfcwdlanxdyxhw")
    public suspend fun kind(`value`: Either<String, SelectorKind>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kind = mapped
    }

    /**
     * @param value The selector kind.
     */
    @JvmName("mdbqgtlesdqohkkp")
    public fun kind(`value`: String) {
        val toBeMapped = Either.ofLeft<String, SelectorKind>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.kind = mapped
    }

    /**
     * @param value The selector kind.
     */
    @JvmName("ydvwdkxcklrgxdlg")
    public fun kind(`value`: SelectorKind) {
        val toBeMapped = Either.ofRight<String, SelectorKind>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.kind = mapped
    }

    /**
     * @param value The list of values to filter out.
     */
    @JvmName("ivjmenqehiygmvru")
    public suspend fun notIn(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.notIn = mapped
    }

    /**
     * @param values The list of values to filter out.
     */
    @JvmName("bsuhmjhnbdaoaxde")
    public suspend fun notIn(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.notIn = mapped
    }

    internal fun build(): SelectorArgs = SelectorArgs(
        `in` = `in`,
        kind = kind,
        notIn = notIn,
    )
}
