@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.authorization.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Access Review Instance.
 * @property backupReviewers This is the collection of backup reviewers.
 * @property endDateTime The DateTime when the review instance is scheduled to end.
 * @property id The access review instance id.
 * @property name The access review instance name.
 * @property reviewers This is the collection of reviewers.
 * @property reviewersType This field specifies the type of reviewers for a review. Usually for a review, reviewers are explicitly assigned. However, in some cases, the reviewers may not be assigned and instead be chosen dynamically. For example managers review or self review.
 * @property startDateTime The DateTime when the review instance is scheduled to be start.
 * @property status This read-only field specifies the status of an access review instance.
 * @property type The resource type.
 */
public data class AccessReviewInstanceResponse(
    public val backupReviewers: List<AccessReviewReviewerResponse>? = null,
    public val endDateTime: String? = null,
    public val id: String,
    public val name: String,
    public val reviewers: List<AccessReviewReviewerResponse>? = null,
    public val reviewersType: String,
    public val startDateTime: String? = null,
    public val status: String,
    public val type: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.authorization.outputs.AccessReviewInstanceResponse):
            AccessReviewInstanceResponse = AccessReviewInstanceResponse(
            backupReviewers = javaType.backupReviewers().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.authorization.kotlin.outputs.AccessReviewReviewerResponse.Companion.toKotlin(args0)
                })
            }),
            endDateTime = javaType.endDateTime().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            name = javaType.name(),
            reviewers = javaType.reviewers().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.authorization.kotlin.outputs.AccessReviewReviewerResponse.Companion.toKotlin(args0)
                })
            }),
            reviewersType = javaType.reviewersType(),
            startDateTime = javaType.startDateTime().map({ args0 -> args0 }).orElse(null),
            status = javaType.status(),
            type = javaType.type(),
        )
    }
}
