@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.authorization.kotlin.outputs

import kotlin.Any
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * The policy exemption.
 * @property assignmentScopeValidation The option whether validate the exemption is at or under the assignment scope.
 * @property description The description of the policy exemption.
 * @property displayName The display name of the policy exemption.
 * @property exemptionCategory The policy exemption category. Possible values are Waiver and Mitigated.
 * @property expiresOn The expiration date and time (in UTC ISO 8601 format yyyy-MM-ddTHH:mm:ssZ) of the policy exemption.
 * @property id The ID of the policy exemption.
 * @property metadata The policy exemption metadata. Metadata is an open ended object and is typically a collection of key value pairs.
 * @property name The name of the policy exemption.
 * @property policyAssignmentId The ID of the policy assignment that is being exempted.
 * @property policyDefinitionReferenceIds The policy definition reference ID list when the associated policy assignment is an assignment of a policy set definition.
 * @property resourceSelectors The resource selector list to filter policies by resource properties.
 * @property systemData Azure Resource Manager metadata containing createdBy and modifiedBy information.
 * @property type The type of the resource (Microsoft.Authorization/policyExemptions).
 */
public data class GetPolicyExemptionResult(
    public val assignmentScopeValidation: String? = null,
    public val description: String? = null,
    public val displayName: String? = null,
    public val exemptionCategory: String,
    public val expiresOn: String? = null,
    public val id: String,
    public val metadata: Any? = null,
    public val name: String,
    public val policyAssignmentId: String,
    public val policyDefinitionReferenceIds: List<String>? = null,
    public val resourceSelectors: List<ResourceSelectorResponse>? = null,
    public val systemData: SystemDataResponse,
    public val type: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.authorization.outputs.GetPolicyExemptionResult):
            GetPolicyExemptionResult = GetPolicyExemptionResult(
            assignmentScopeValidation = javaType.assignmentScopeValidation().map({ args0 ->
                args0
            }).orElse(null),
            description = javaType.description().map({ args0 -> args0 }).orElse(null),
            displayName = javaType.displayName().map({ args0 -> args0 }).orElse(null),
            exemptionCategory = javaType.exemptionCategory(),
            expiresOn = javaType.expiresOn().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            metadata = javaType.metadata().map({ args0 -> args0 }).orElse(null),
            name = javaType.name(),
            policyAssignmentId = javaType.policyAssignmentId(),
            policyDefinitionReferenceIds = javaType.policyDefinitionReferenceIds().map({ args0 -> args0 }),
            resourceSelectors = javaType.resourceSelectors().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.authorization.kotlin.outputs.ResourceSelectorResponse.Companion.toKotlin(args0)
                })
            }),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.authorization.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            type = javaType.type(),
        )
    }
}
