@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.authorization.kotlin.outputs

import kotlin.Any
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * The policy set definition.
 * @property description The policy set definition description.
 * @property displayName The display name of the policy set definition.
 * @property id The ID of the policy set definition.
 * @property metadata The policy set definition metadata.  Metadata is an open ended object and is typically a collection of key value pairs.
 * @property name The name of the policy set definition.
 * @property parameters The policy set definition parameters that can be used in policy definition references.
 * @property policyDefinitionGroups The metadata describing groups of policy definition references within the policy set definition.
 * @property policyDefinitions An array of policy definition references.
 * @property policyType The type of policy definition. Possible values are NotSpecified, BuiltIn, Custom, and Static.
 * @property systemData The system metadata relating to this resource.
 * @property type The type of the resource (Microsoft.Authorization/policySetDefinitions).
 */
public data class GetPolicySetDefinitionAtManagementGroupResult(
    public val description: String? = null,
    public val displayName: String? = null,
    public val id: String,
    public val metadata: Any? = null,
    public val name: String,
    public val parameters: Map<String, ParameterDefinitionsValueResponse>? = null,
    public val policyDefinitionGroups: List<PolicyDefinitionGroupResponse>? = null,
    public val policyDefinitions: List<PolicyDefinitionReferenceResponse>,
    public val policyType: String? = null,
    public val systemData: SystemDataResponse,
    public val type: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.authorization.outputs.GetPolicySetDefinitionAtManagementGroupResult):
            GetPolicySetDefinitionAtManagementGroupResult =
            GetPolicySetDefinitionAtManagementGroupResult(
                description = javaType.description().map({ args0 -> args0 }).orElse(null),
                displayName = javaType.displayName().map({ args0 -> args0 }).orElse(null),
                id = javaType.id(),
                metadata = javaType.metadata().map({ args0 -> args0 }).orElse(null),
                name = javaType.name(),
                parameters = javaType.parameters().map({ args0 ->
                    args0.key.to(
                        args0.value.let({ args0 ->
                            com.pulumi.azurenative.authorization.kotlin.outputs.ParameterDefinitionsValueResponse.Companion.toKotlin(args0)
                        }),
                    )
                }).toMap(),
                policyDefinitionGroups = javaType.policyDefinitionGroups().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.azurenative.authorization.kotlin.outputs.PolicyDefinitionGroupResponse.Companion.toKotlin(args0)
                    })
                }),
                policyDefinitions = javaType.policyDefinitions().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.azurenative.authorization.kotlin.outputs.PolicyDefinitionReferenceResponse.Companion.toKotlin(args0)
                    })
                }),
                policyType = javaType.policyType().map({ args0 -> args0 }).orElse(null),
                systemData = javaType.systemData().let({ args0 ->
                    com.pulumi.azurenative.authorization.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
                }),
                type = javaType.type(),
            )
    }
}
