@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.authorization.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Details of the resource scope
 * @property displayName Display name of the resource
 * @property id Scope id of the resource
 * @property type Type of the resource
 */
public data class PolicyAssignmentPropertiesResponseScope(
    public val displayName: String? = null,
    public val id: String? = null,
    public val type: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.authorization.outputs.PolicyAssignmentPropertiesResponseScope):
            PolicyAssignmentPropertiesResponseScope = PolicyAssignmentPropertiesResponseScope(
            displayName = javaType.displayName().map({ args0 -> args0 }).orElse(null),
            id = javaType.id().map({ args0 -> args0 }).orElse(null),
            type = javaType.type().map({ args0 -> args0 }).orElse(null),
        )
    }
}
