@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.authorization.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * The role management policy notification rule.
 * @property id The id of the rule.
 * @property isDefaultRecipientsEnabled Determines if the notification will be sent to the recipient type specified in the policy rule.
 * @property notificationLevel The notification level.
 * @property notificationRecipients The list of notification recipients.
 * @property notificationType The type of notification.
 * @property recipientType The recipient type.
 * @property ruleType The type of rule
 * Expected value is 'RoleManagementPolicyNotificationRule'.
 * @property target The target of the current rule.
 */
public data class RoleManagementPolicyNotificationRuleResponse(
    public val id: String? = null,
    public val isDefaultRecipientsEnabled: Boolean? = null,
    public val notificationLevel: String? = null,
    public val notificationRecipients: List<String>? = null,
    public val notificationType: String? = null,
    public val recipientType: String? = null,
    public val ruleType: String,
    public val target: RoleManagementPolicyRuleTargetResponse? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.authorization.outputs.RoleManagementPolicyNotificationRuleResponse):
            RoleManagementPolicyNotificationRuleResponse = RoleManagementPolicyNotificationRuleResponse(
            id = javaType.id().map({ args0 -> args0 }).orElse(null),
            isDefaultRecipientsEnabled = javaType.isDefaultRecipientsEnabled().map({ args0 ->
                args0
            }).orElse(null),
            notificationLevel = javaType.notificationLevel().map({ args0 -> args0 }).orElse(null),
            notificationRecipients = javaType.notificationRecipients().map({ args0 -> args0 }),
            notificationType = javaType.notificationType().map({ args0 -> args0 }).orElse(null),
            recipientType = javaType.recipientType().map({ args0 -> args0 }).orElse(null),
            ruleType = javaType.ruleType(),
            target = javaType.target().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.authorization.kotlin.outputs.RoleManagementPolicyRuleTargetResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
