@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.automanage.kotlin

import com.pulumi.azurenative.automanage.kotlin.outputs.ConfigurationProfileAssignmentPropertiesResponse
import com.pulumi.azurenative.automanage.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import com.pulumi.azurenative.automanage.kotlin.outputs.ConfigurationProfileAssignmentPropertiesResponse.Companion.toKotlin as configurationProfileAssignmentPropertiesResponseToKotlin
import com.pulumi.azurenative.automanage.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [ConfigurationProfileHCRPAssignment].
 */
@PulumiTagMarker
public class ConfigurationProfileHCRPAssignmentResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ConfigurationProfileHCRPAssignmentArgs = ConfigurationProfileHCRPAssignmentArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ConfigurationProfileHCRPAssignmentArgsBuilder.() -> Unit) {
        val builder = ConfigurationProfileHCRPAssignmentArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): ConfigurationProfileHCRPAssignment {
        val builtJavaResource =
            com.pulumi.azurenative.automanage.ConfigurationProfileHCRPAssignment(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return ConfigurationProfileHCRPAssignment(builtJavaResource)
    }
}

/**
 * Configuration profile assignment is an association between a VM and automanage profile configuration.
 * Azure REST API version: 2022-05-04.
 * ## Example Usage
 * ### Create or update HCRP configuration profile assignment
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var configurationProfileHCRPAssignment = new AzureNative.Automanage.ConfigurationProfileHCRPAssignment("configurationProfileHCRPAssignment", new()
 *     {
 *         ConfigurationProfileAssignmentName = "default",
 *         MachineName = "myMachineName",
 *         Properties = new AzureNative.Automanage.Inputs.ConfigurationProfileAssignmentPropertiesArgs
 *         {
 *             ConfigurationProfile = "/providers/Microsoft.Automanage/bestPractices/AzureBestPracticesProduction",
 *         },
 *         ResourceGroupName = "myResourceGroupName",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/automanage/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := automanage.NewConfigurationProfileHCRPAssignment(ctx, "configurationProfileHCRPAssignment", &automanage.ConfigurationProfileHCRPAssignmentArgs{
 * 			ConfigurationProfileAssignmentName: pulumi.String("default"),
 * 			MachineName:                        pulumi.String("myMachineName"),
 * 			Properties: &automanage.ConfigurationProfileAssignmentPropertiesArgs{
 * 				ConfigurationProfile: pulumi.String("/providers/Microsoft.Automanage/bestPractices/AzureBestPracticesProduction"),
 * 			},
 * 			ResourceGroupName: pulumi.String("myResourceGroupName"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.automanage.ConfigurationProfileHCRPAssignment;
 * import com.pulumi.azurenative.automanage.ConfigurationProfileHCRPAssignmentArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var configurationProfileHCRPAssignment = new ConfigurationProfileHCRPAssignment("configurationProfileHCRPAssignment", ConfigurationProfileHCRPAssignmentArgs.builder()
 *             .configurationProfileAssignmentName("default")
 *             .machineName("myMachineName")
 *             .properties(Map.of("configurationProfile", "/providers/Microsoft.Automanage/bestPractices/AzureBestPracticesProduction"))
 *             .resourceGroupName("myResourceGroupName")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:automanage:ConfigurationProfileHCRPAssignment default /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.HybridCompute/machines/{machineName}/providers/Microsoft.Automanage/configurationProfileAssignments/{configurationProfileAssignmentName}
 * ```
 */
public class ConfigurationProfileHCRPAssignment internal constructor(
    override val javaResource: com.pulumi.azurenative.automanage.ConfigurationProfileHCRPAssignment,
) : KotlinCustomResource(javaResource, ConfigurationProfileHCRPAssignmentMapper) {
    /**
     * Azure resource id. Indicates if this resource is managed by another Azure resource.
     */
    public val managedBy: Output<String>
        get() = javaResource.managedBy().applyValue({ args0 -> args0 })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Properties of the configuration profile assignment.
     */
    public val properties: Output<ConfigurationProfileAssignmentPropertiesResponse>
        get() = javaResource.properties().applyValue({ args0 ->
            args0.let({ args0 ->
                configurationProfileAssignmentPropertiesResponseToKotlin(args0)
            })
        })

    /**
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object ConfigurationProfileHCRPAssignmentMapper :
    ResourceMapper<ConfigurationProfileHCRPAssignment> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.automanage.ConfigurationProfileHCRPAssignment::class == javaResource::class

    override fun map(javaResource: Resource): ConfigurationProfileHCRPAssignment =
        ConfigurationProfileHCRPAssignment(
            javaResource as
                com.pulumi.azurenative.automanage.ConfigurationProfileHCRPAssignment,
        )
}

/**
 * @see [ConfigurationProfileHCRPAssignment].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ConfigurationProfileHCRPAssignment].
 */
public suspend fun configurationProfileHCRPAssignment(
    name: String,
    block: suspend ConfigurationProfileHCRPAssignmentResourceBuilder.() -> Unit,
):
    ConfigurationProfileHCRPAssignment {
    val builder = ConfigurationProfileHCRPAssignmentResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ConfigurationProfileHCRPAssignment].
 * @param name The _unique_ name of the resulting resource.
 */
public fun configurationProfileHCRPAssignment(name: String): ConfigurationProfileHCRPAssignment {
    val builder = ConfigurationProfileHCRPAssignmentResourceBuilder()
    builder.name(name)
    return builder.build()
}
