@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.automanage.kotlin

import com.pulumi.azurenative.automanage.ConfigurationProfileHCRPAssignmentArgs.builder
import com.pulumi.azurenative.automanage.kotlin.inputs.ConfigurationProfileAssignmentPropertiesArgs
import com.pulumi.azurenative.automanage.kotlin.inputs.ConfigurationProfileAssignmentPropertiesArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Configuration profile assignment is an association between a VM and automanage profile configuration.
 * Azure REST API version: 2022-05-04.
 * ## Example Usage
 * ### Create or update HCRP configuration profile assignment
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var configurationProfileHCRPAssignment = new AzureNative.Automanage.ConfigurationProfileHCRPAssignment("configurationProfileHCRPAssignment", new()
 *     {
 *         ConfigurationProfileAssignmentName = "default",
 *         MachineName = "myMachineName",
 *         Properties = new AzureNative.Automanage.Inputs.ConfigurationProfileAssignmentPropertiesArgs
 *         {
 *             ConfigurationProfile = "/providers/Microsoft.Automanage/bestPractices/AzureBestPracticesProduction",
 *         },
 *         ResourceGroupName = "myResourceGroupName",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/automanage/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := automanage.NewConfigurationProfileHCRPAssignment(ctx, "configurationProfileHCRPAssignment", &automanage.ConfigurationProfileHCRPAssignmentArgs{
 * 			ConfigurationProfileAssignmentName: pulumi.String("default"),
 * 			MachineName:                        pulumi.String("myMachineName"),
 * 			Properties: &automanage.ConfigurationProfileAssignmentPropertiesArgs{
 * 				ConfigurationProfile: pulumi.String("/providers/Microsoft.Automanage/bestPractices/AzureBestPracticesProduction"),
 * 			},
 * 			ResourceGroupName: pulumi.String("myResourceGroupName"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.automanage.ConfigurationProfileHCRPAssignment;
 * import com.pulumi.azurenative.automanage.ConfigurationProfileHCRPAssignmentArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var configurationProfileHCRPAssignment = new ConfigurationProfileHCRPAssignment("configurationProfileHCRPAssignment", ConfigurationProfileHCRPAssignmentArgs.builder()
 *             .configurationProfileAssignmentName("default")
 *             .machineName("myMachineName")
 *             .properties(Map.of("configurationProfile", "/providers/Microsoft.Automanage/bestPractices/AzureBestPracticesProduction"))
 *             .resourceGroupName("myResourceGroupName")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:automanage:ConfigurationProfileHCRPAssignment default /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.HybridCompute/machines/{machineName}/providers/Microsoft.Automanage/configurationProfileAssignments/{configurationProfileAssignmentName}
 * ```
 * @property configurationProfileAssignmentName Name of the configuration profile assignment. Only default is supported.
 * @property machineName The name of the Arc machine.
 * @property properties Properties of the configuration profile assignment.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 */
public data class ConfigurationProfileHCRPAssignmentArgs(
    public val configurationProfileAssignmentName: Output<String>? = null,
    public val machineName: Output<String>? = null,
    public val properties: Output<ConfigurationProfileAssignmentPropertiesArgs>? = null,
    public val resourceGroupName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.automanage.ConfigurationProfileHCRPAssignmentArgs> {
    override fun toJava(): com.pulumi.azurenative.automanage.ConfigurationProfileHCRPAssignmentArgs =
        com.pulumi.azurenative.automanage.ConfigurationProfileHCRPAssignmentArgs.builder()
            .configurationProfileAssignmentName(
                configurationProfileAssignmentName?.applyValue({ args0 ->
                    args0
                }),
            )
            .machineName(machineName?.applyValue({ args0 -> args0 }))
            .properties(properties?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ConfigurationProfileHCRPAssignmentArgs].
 */
@PulumiTagMarker
public class ConfigurationProfileHCRPAssignmentArgsBuilder internal constructor() {
    private var configurationProfileAssignmentName: Output<String>? = null

    private var machineName: Output<String>? = null

    private var properties: Output<ConfigurationProfileAssignmentPropertiesArgs>? = null

    private var resourceGroupName: Output<String>? = null

    /**
     * @param value Name of the configuration profile assignment. Only default is supported.
     */
    @JvmName("umamrmusvdtvbqyc")
    public suspend fun configurationProfileAssignmentName(`value`: Output<String>) {
        this.configurationProfileAssignmentName = value
    }

    /**
     * @param value The name of the Arc machine.
     */
    @JvmName("cobnpfqdridvkemf")
    public suspend fun machineName(`value`: Output<String>) {
        this.machineName = value
    }

    /**
     * @param value Properties of the configuration profile assignment.
     */
    @JvmName("egcsqsmrcqnbgtgn")
    public suspend fun properties(`value`: Output<ConfigurationProfileAssignmentPropertiesArgs>) {
        this.properties = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("symnmokcgkkjmhrg")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Name of the configuration profile assignment. Only default is supported.
     */
    @JvmName("ybbxeihcouimharv")
    public suspend fun configurationProfileAssignmentName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.configurationProfileAssignmentName = mapped
    }

    /**
     * @param value The name of the Arc machine.
     */
    @JvmName("hshfkdsggjtrplit")
    public suspend fun machineName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.machineName = mapped
    }

    /**
     * @param value Properties of the configuration profile assignment.
     */
    @JvmName("ualmpsbloonefxna")
    public suspend fun properties(`value`: ConfigurationProfileAssignmentPropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.properties = mapped
    }

    /**
     * @param argument Properties of the configuration profile assignment.
     */
    @JvmName("jxnlembsvpqrmgin")
    public suspend
    fun properties(argument: suspend ConfigurationProfileAssignmentPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = ConfigurationProfileAssignmentPropertiesArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.properties = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("cmnoohxebhdqjyif")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    internal fun build(): ConfigurationProfileHCRPAssignmentArgs =
        ConfigurationProfileHCRPAssignmentArgs(
            configurationProfileAssignmentName = configurationProfileAssignmentName,
            machineName = machineName,
            properties = properties,
            resourceGroupName = resourceGroupName,
        )
}
