@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.automanage.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * The type of identity used for the Automanage account. Currently, the only supported type is 'SystemAssigned', which implicitly creates an identity.
 */
public enum class ResourceIdentityType(
    public val javaValue: com.pulumi.azurenative.automanage.enums.ResourceIdentityType,
) : ConvertibleToJava<com.pulumi.azurenative.automanage.enums.ResourceIdentityType> {
    SystemAssigned(com.pulumi.azurenative.automanage.enums.ResourceIdentityType.SystemAssigned),
    None(com.pulumi.azurenative.automanage.enums.ResourceIdentityType.None),
    ;

    override fun toJava(): com.pulumi.azurenative.automanage.enums.ResourceIdentityType = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.automanage.enums.ResourceIdentityType):
            ResourceIdentityType = ResourceIdentityType.values().first { it.javaValue == javaType }
    }
}
