@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.automanage.kotlin.inputs

import com.pulumi.azurenative.automanage.inputs.GetConfigurationProfilePreferencePlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property configurationProfilePreferenceName The configuration profile preference name.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 */
public data class GetConfigurationProfilePreferencePlainArgs(
    public val configurationProfilePreferenceName: String,
    public val resourceGroupName: String,
) :
    ConvertibleToJava<com.pulumi.azurenative.automanage.inputs.GetConfigurationProfilePreferencePlainArgs> {
    override fun toJava():
        com.pulumi.azurenative.automanage.inputs.GetConfigurationProfilePreferencePlainArgs =
        com.pulumi.azurenative.automanage.inputs.GetConfigurationProfilePreferencePlainArgs.builder()
            .configurationProfilePreferenceName(configurationProfilePreferenceName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetConfigurationProfilePreferencePlainArgs].
 */
@PulumiTagMarker
public class GetConfigurationProfilePreferencePlainArgsBuilder internal constructor() {
    private var configurationProfilePreferenceName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value The configuration profile preference name.
     */
    @JvmName("dyqldymwcvdivxov")
    public suspend fun configurationProfilePreferenceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.configurationProfilePreferenceName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("sckevbtmetqyosfc")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetConfigurationProfilePreferencePlainArgs =
        GetConfigurationProfilePreferencePlainArgs(
            configurationProfilePreferenceName = configurationProfilePreferenceName ?: throw
                PulumiNullFieldException("configurationProfilePreferenceName"),
            resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        )
}
