@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.automanage.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 * Automanage configuration profile VM Backup preferences.
 * @property instantRpRetentionRangeInDays Instant RP retention policy range in days
 * @property retentionPolicy Retention policy with the details on backup copy retention ranges.
 * @property schedulePolicy Backup schedule specified as part of backup policy.
 * @property timeZone TimeZone optional input as string. For example: Pacific Standard Time
 */
public data class ConfigurationProfilePreferenceVmBackupResponse(
    public val instantRpRetentionRangeInDays: Int? = null,
    public val retentionPolicy: String? = null,
    public val schedulePolicy: String? = null,
    public val timeZone: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.automanage.outputs.ConfigurationProfilePreferenceVmBackupResponse):
            ConfigurationProfilePreferenceVmBackupResponse =
            ConfigurationProfilePreferenceVmBackupResponse(
                instantRpRetentionRangeInDays = javaType.instantRpRetentionRangeInDays().map({ args0 ->
                    args0
                }).orElse(null),
                retentionPolicy = javaType.retentionPolicy().map({ args0 -> args0 }).orElse(null),
                schedulePolicy = javaType.schedulePolicy().map({ args0 -> args0 }).orElse(null),
                timeZone = javaType.timeZone().map({ args0 -> args0 }).orElse(null),
            )
    }
}
