@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.automation.kotlin

import com.pulumi.azurenative.automation.kotlin.outputs.EncryptionPropertiesResponse
import com.pulumi.azurenative.automation.kotlin.outputs.IdentityResponse
import com.pulumi.azurenative.automation.kotlin.outputs.PrivateEndpointConnectionResponse
import com.pulumi.azurenative.automation.kotlin.outputs.SkuResponse
import com.pulumi.azurenative.automation.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.azurenative.automation.kotlin.outputs.EncryptionPropertiesResponse.Companion.toKotlin as encryptionPropertiesResponseToKotlin
import com.pulumi.azurenative.automation.kotlin.outputs.IdentityResponse.Companion.toKotlin as identityResponseToKotlin
import com.pulumi.azurenative.automation.kotlin.outputs.PrivateEndpointConnectionResponse.Companion.toKotlin as privateEndpointConnectionResponseToKotlin
import com.pulumi.azurenative.automation.kotlin.outputs.SkuResponse.Companion.toKotlin as skuResponseToKotlin
import com.pulumi.azurenative.automation.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [AutomationAccount].
 */
@PulumiTagMarker
public class AutomationAccountResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: AutomationAccountArgs = AutomationAccountArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend AutomationAccountArgsBuilder.() -> Unit) {
        val builder = AutomationAccountArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): AutomationAccount {
        val builtJavaResource =
            com.pulumi.azurenative.automation.AutomationAccount(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return AutomationAccount(builtJavaResource)
    }
}

/**
 * Definition of the automation account type.
 * Azure REST API version: 2022-08-08. Prior API version in Azure Native 1.x: 2021-06-22.
 * Other available API versions: 2023-05-15-preview, 2023-11-01.
 * ## Example Usage
 * ### Create or update automation account
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var automationAccount = new AzureNative.Automation.AutomationAccount("automationAccount", new()
 *     {
 *         AutomationAccountName = "myAutomationAccount9",
 *         Location = "East US 2",
 *         Name = "myAutomationAccount9",
 *         ResourceGroupName = "rg",
 *         Sku = new AzureNative.Automation.Inputs.SkuArgs
 *         {
 *             Name = "Free",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/automation/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := automation.NewAutomationAccount(ctx, "automationAccount", &automation.AutomationAccountArgs{
 * 			AutomationAccountName: pulumi.String("myAutomationAccount9"),
 * 			Location:              pulumi.String("East US 2"),
 * 			Name:                  pulumi.String("myAutomationAccount9"),
 * 			ResourceGroupName:     pulumi.String("rg"),
 * 			Sku: &automation.SkuArgs{
 * 				Name: pulumi.String("Free"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.automation.AutomationAccount;
 * import com.pulumi.azurenative.automation.AutomationAccountArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var automationAccount = new AutomationAccount("automationAccount", AutomationAccountArgs.builder()
 *             .automationAccountName("myAutomationAccount9")
 *             .location("East US 2")
 *             .name("myAutomationAccount9")
 *             .resourceGroupName("rg")
 *             .sku(Map.of("name", "Free"))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:automation:AutomationAccount ContoseAutomationAccount /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Automation/automationAccounts/{automationAccountName}
 * ```
 */
public class AutomationAccount internal constructor(
    override val javaResource: com.pulumi.azurenative.automation.AutomationAccount,
) : KotlinCustomResource(javaResource, AutomationAccountMapper) {
    /**
     * URL of automation hybrid service which is used for hybrid worker on-boarding.
     */
    public val automationHybridServiceUrl: Output<String>?
        get() = javaResource.automationHybridServiceUrl().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Gets the creation time.
     */
    public val creationTime: Output<String>
        get() = javaResource.creationTime().applyValue({ args0 -> args0 })

    /**
     * Gets or sets the description.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Indicates whether requests using non-AAD authentication are blocked
     */
    public val disableLocalAuth: Output<Boolean>?
        get() = javaResource.disableLocalAuth().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Encryption properties for the automation account
     */
    public val encryption: Output<EncryptionPropertiesResponse>?
        get() = javaResource.encryption().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    encryptionPropertiesResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * Gets or sets the etag of the resource.
     */
    public val etag: Output<String>?
        get() = javaResource.etag().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Identity for the resource.
     */
    public val identity: Output<IdentityResponse>?
        get() = javaResource.identity().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    identityResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * Gets or sets the last modified by.
     */
    public val lastModifiedBy: Output<String>?
        get() = javaResource.lastModifiedBy().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Gets the last modified time.
     */
    public val lastModifiedTime: Output<String>
        get() = javaResource.lastModifiedTime().applyValue({ args0 -> args0 })

    /**
     * The Azure Region where the resource lives
     */
    public val location: Output<String>?
        get() = javaResource.location().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * List of Automation operations supported by the Automation resource provider.
     */
    public val privateEndpointConnections: Output<List<PrivateEndpointConnectionResponse>>?
        get() = javaResource.privateEndpointConnections().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 ->
                        privateEndpointConnectionResponseToKotlin(args0)
                    })
                })
            }).orElse(null)
        })

    /**
     * Indicates whether traffic on the non-ARM endpoint (Webhook/Agent) is allowed from the public internet
     */
    public val publicNetworkAccess: Output<Boolean>?
        get() = javaResource.publicNetworkAccess().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Gets or sets the SKU of account.
     */
    public val sku: Output<SkuResponse>?
        get() = javaResource.sku().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    skuResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * Gets status of account.
     */
    public val state: Output<String>
        get() = javaResource.state().applyValue({ args0 -> args0 })

    /**
     * Resource system metadata.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * Resource tags.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * The type of the resource.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object AutomationAccountMapper : ResourceMapper<AutomationAccount> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.automation.AutomationAccount::class == javaResource::class

    override fun map(javaResource: Resource): AutomationAccount = AutomationAccount(
        javaResource as
            com.pulumi.azurenative.automation.AutomationAccount,
    )
}

/**
 * @see [AutomationAccount].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [AutomationAccount].
 */
public suspend fun automationAccount(
    name: String,
    block: suspend AutomationAccountResourceBuilder.() -> Unit,
): AutomationAccount {
    val builder = AutomationAccountResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [AutomationAccount].
 * @param name The _unique_ name of the resulting resource.
 */
public fun automationAccount(name: String): AutomationAccount {
    val builder = AutomationAccountResourceBuilder()
    builder.name(name)
    return builder.build()
}
