@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.automation.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [Credential].
 */
@PulumiTagMarker
public class CredentialResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: CredentialArgs = CredentialArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend CredentialArgsBuilder.() -> Unit) {
        val builder = CredentialArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): Credential {
        val builtJavaResource = com.pulumi.azurenative.automation.Credential(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Credential(builtJavaResource)
    }
}

/**
 * Definition of the credential.
 * Azure REST API version: 2022-08-08. Prior API version in Azure Native 1.x: 2019-06-01.
 * Other available API versions: 2023-05-15-preview, 2023-11-01.
 * ## Example Usage
 * ### Create a credential
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var credential = new AzureNative.Automation.Credential("credential", new()
 *     {
 *         AutomationAccountName = "myAutomationAccount18",
 *         CredentialName = "myCredential",
 *         Description = "my description goes here",
 *         Name = "myCredential",
 *         Password = "<password>",
 *         ResourceGroupName = "rg",
 *         UserName = "mylingaiah",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/automation/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := automation.NewCredential(ctx, "credential", &automation.CredentialArgs{
 * 			AutomationAccountName: pulumi.String("myAutomationAccount18"),
 * 			CredentialName:        pulumi.String("myCredential"),
 * 			Description:           pulumi.String("my description goes here"),
 * 			Name:                  pulumi.String("myCredential"),
 * 			Password:              pulumi.String("<password>"),
 * 			ResourceGroupName:     pulumi.String("rg"),
 * 			UserName:              pulumi.String("mylingaiah"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.automation.Credential;
 * import com.pulumi.azurenative.automation.CredentialArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var credential = new Credential("credential", CredentialArgs.builder()
 *             .automationAccountName("myAutomationAccount18")
 *             .credentialName("myCredential")
 *             .description("my description goes here")
 *             .name("myCredential")
 *             .password("<password>")
 *             .resourceGroupName("rg")
 *             .userName("mylingaiah")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:automation:Credential myCredential /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Automation/automationAccounts/{automationAccountName}/credentials/{credentialName}
 * ```
 */
public class Credential internal constructor(
    override val javaResource: com.pulumi.azurenative.automation.Credential,
) : KotlinCustomResource(javaResource, CredentialMapper) {
    /**
     * Gets the creation time.
     */
    public val creationTime: Output<String>
        get() = javaResource.creationTime().applyValue({ args0 -> args0 })

    /**
     * Gets or sets the description.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Gets the last modified time.
     */
    public val lastModifiedTime: Output<String>
        get() = javaResource.lastModifiedTime().applyValue({ args0 -> args0 })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The type of the resource.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })

    /**
     * Gets the user name of the credential.
     */
    public val userName: Output<String>
        get() = javaResource.userName().applyValue({ args0 -> args0 })
}

public object CredentialMapper : ResourceMapper<Credential> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.automation.Credential::class == javaResource::class

    override fun map(javaResource: Resource): Credential = Credential(
        javaResource as
            com.pulumi.azurenative.automation.Credential,
    )
}

/**
 * @see [Credential].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Credential].
 */
public suspend fun credential(name: String, block: suspend CredentialResourceBuilder.() -> Unit):
    Credential {
    val builder = CredentialResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Credential].
 * @param name The _unique_ name of the resulting resource.
 */
public fun credential(name: String): Credential {
    val builder = CredentialResourceBuilder()
    builder.name(name)
    return builder.build()
}
