@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.automation.kotlin

import com.pulumi.azurenative.automation.kotlin.outputs.DscConfigurationAssociationPropertyResponse
import com.pulumi.azurenative.automation.kotlin.outputs.DscConfigurationAssociationPropertyResponse.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Double
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [DscNodeConfiguration].
 */
@PulumiTagMarker
public class DscNodeConfigurationResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: DscNodeConfigurationArgs = DscNodeConfigurationArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend DscNodeConfigurationArgsBuilder.() -> Unit) {
        val builder = DscNodeConfigurationArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): DscNodeConfiguration {
        val builtJavaResource =
            com.pulumi.azurenative.automation.DscNodeConfiguration(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return DscNodeConfiguration(builtJavaResource)
    }
}

/**
 * Definition of the dsc node configuration.
 * Azure REST API version: 2022-08-08. Prior API version in Azure Native 1.x: 2019-06-01.
 * Other available API versions: 2023-05-15-preview, 2023-11-01.
 * ## Example Usage
 * ### Create node configuration
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var dscNodeConfiguration = new AzureNative.Automation.DscNodeConfiguration("dscNodeConfiguration", new()
 *     {
 *         AutomationAccountName = "myAutomationAccount20",
 *         Configuration = new AzureNative.Automation.Inputs.DscConfigurationAssociationPropertyArgs
 *         {
 *             Name = "configName",
 *         },
 *         IncrementNodeConfigurationBuild = true,
 *         Name = "configName.nodeConfigName",
 *         NodeConfigurationName = "configName.nodeConfigName",
 *         ResourceGroupName = "rg",
 *         Source = new AzureNative.Automation.Inputs.ContentSourceArgs
 *         {
 *             Hash = new AzureNative.Automation.Inputs.ContentHashArgs
 *             {
 *                 Algorithm = "sha256",
 *                 Value = "6DE256A57F01BFA29B88696D5E77A383D6E61484C7686E8DB955FA10ACE9FFE5",
 *             },
 *             Type = "embeddedContent",
 *             Value = @"
 * instance of MSFT_RoleResource as $MSFT_RoleResource1ref
 * {
 * ResourceID = ""[WindowsFeature]IIS"";
 *  Ensure = ""Present"";
 *  SourceInfo = ""::3::32::WindowsFeature"";
 *  Name = ""Web-Server"";
 *  ModuleName = ""PsDesiredStateConfiguration"";
 * ModuleVersion = ""1.0"";
 *  ConfigurationName = ""configName"";
 * };
 * instance of OMI_ConfigurationDocument
 *                     {
 *  Version=""2.0.0"";
 *                         MinimumCompatibleVersion = ""1.0.0"";
 *                         CompatibleVersionAdditionalProperties= {""Omi_BaseResource:ConfigurationName""};
 *                         Author=""weijiel"";
 *                         GenerationDate=""03/30/2017 13:40:25"";
 *                         GenerationHost=""TEST-BACKEND"";
 *                         Name=""configName"";
 *                     };
 * ",
 *             Version = "1.0",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/automation/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := automation.NewDscNodeConfiguration(ctx, "dscNodeConfiguration", &automation.DscNodeConfigurationArgs{
 * 			AutomationAccountName: pulumi.String("myAutomationAccount20"),
 * 			Configuration: &automation.DscConfigurationAssociationPropertyArgs{
 * 				Name: pulumi.String("configName"),
 * 			},
 * 			IncrementNodeConfigurationBuild: pulumi.Bool(true),
 * 			Name:                            pulumi.String("configName.nodeConfigName"),
 * 			NodeConfigurationName:           pulumi.String("configName.nodeConfigName"),
 * 			ResourceGroupName:               pulumi.String("rg"),
 * 			Source: &automation.ContentSourceArgs{
 * 				Hash: &automation.ContentHashArgs{
 * 					Algorithm: pulumi.String("sha256"),
 * 					Value:     pulumi.String("6DE256A57F01BFA29B88696D5E77A383D6E61484C7686E8DB955FA10ACE9FFE5"),
 * 				},
 * 				Type: pulumi.String("embeddedContent"),
 * 				Value: pulumi.String(`
 * instance of MSFT_RoleResource as $MSFT_RoleResource1ref
 * {
 * ResourceID = "[WindowsFeature]IIS";
 *  Ensure = "Present";
 *  SourceInfo = "::3::32::WindowsFeature";
 *  Name = "Web-Server";
 *  ModuleName = "PsDesiredStateConfiguration";
 * ModuleVersion = "1.0";
 *  ConfigurationName = "configName";
 * };
 * instance of OMI_ConfigurationDocument
 *                     {
 *  Version="2.0.0";
 *                         MinimumCompatibleVersion = "1.0.0";
 *                         CompatibleVersionAdditionalProperties= {"Omi_BaseResource:ConfigurationName"};
 *                         Author="weijiel";
 *                         GenerationDate="03/30/2017 13:40:25";
 *                         GenerationHost="TEST-BACKEND";
 *                         Name="configName";
 *                     };
 * `),
 * 				Version: pulumi.String("1.0"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.automation.DscNodeConfiguration;
 * import com.pulumi.azurenative.automation.DscNodeConfigurationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var dscNodeConfiguration = new DscNodeConfiguration("dscNodeConfiguration", DscNodeConfigurationArgs.builder()
 *             .automationAccountName("myAutomationAccount20")
 *             .configuration(Map.of("name", "configName"))
 *             .incrementNodeConfigurationBuild(true)
 *             .name("configName.nodeConfigName")
 *             .nodeConfigurationName("configName.nodeConfigName")
 *             .resourceGroupName("rg")
 *             .source(Map.ofEntries(
 *                 Map.entry("hash", Map.ofEntries(
 *                     Map.entry("algorithm", "sha256"),
 *                     Map.entry("value", "6DE256A57F01BFA29B88696D5E77A383D6E61484C7686E8DB955FA10ACE9FFE5")
 *                 )),
 *                 Map.entry("type", "embeddedContent"),
 *                 Map.entry("value", """
 * instance of MSFT_RoleResource as $MSFT_RoleResource1ref
 * {
 * ResourceID = "[WindowsFeature]IIS";
 *  Ensure = "Present";
 *  SourceInfo = "::3::32::WindowsFeature";
 *  Name = "Web-Server";
 *  ModuleName = "PsDesiredStateConfiguration";
 * ModuleVersion = "1.0";
 *  ConfigurationName = "configName";
 * };
 * instance of OMI_ConfigurationDocument
 *                     {
 *  Version="2.0.0";
 *                         MinimumCompatibleVersion = "1.0.0";
 *                         CompatibleVersionAdditionalProperties= {"Omi_BaseResource:ConfigurationName"};
 *                         Author="weijiel";
 *                         GenerationDate="03/30/2017 13:40:25";
 *                         GenerationHost="TEST-BACKEND";
 *                         Name="configName";
 *                     };
 *                 """),
 *                 Map.entry("version", "1.0")
 *             ))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:automation:DscNodeConfiguration configName.nodeConfigName /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Automation/automationAccounts/{automationAccountName}/nodeConfigurations/{nodeConfigurationName}
 * ```
 */
public class DscNodeConfiguration internal constructor(
    override val javaResource: com.pulumi.azurenative.automation.DscNodeConfiguration,
) : KotlinCustomResource(javaResource, DscNodeConfigurationMapper) {
    /**
     * Gets or sets the configuration of the node.
     */
    public val configuration: Output<DscConfigurationAssociationPropertyResponse>?
        get() = javaResource.configuration().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> toKotlin(args0) })
            }).orElse(null)
        })

    /**
     * Gets or sets creation time.
     */
    public val creationTime: Output<String>?
        get() = javaResource.creationTime().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * If a new build version of NodeConfiguration is required.
     */
    public val incrementNodeConfigurationBuild: Output<Boolean>?
        get() = javaResource.incrementNodeConfigurationBuild().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Gets or sets the last modified time.
     */
    public val lastModifiedTime: Output<String>?
        get() = javaResource.lastModifiedTime().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Number of nodes with this node configuration assigned
     */
    public val nodeCount: Output<Double>?
        get() = javaResource.nodeCount().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Source of node configuration.
     */
    public val source: Output<String>?
        get() = javaResource.source().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The type of the resource.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object DscNodeConfigurationMapper : ResourceMapper<DscNodeConfiguration> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.automation.DscNodeConfiguration::class == javaResource::class

    override fun map(javaResource: Resource): DscNodeConfiguration = DscNodeConfiguration(
        javaResource
            as com.pulumi.azurenative.automation.DscNodeConfiguration,
    )
}

/**
 * @see [DscNodeConfiguration].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [DscNodeConfiguration].
 */
public suspend fun dscNodeConfiguration(
    name: String,
    block: suspend DscNodeConfigurationResourceBuilder.() -> Unit,
): DscNodeConfiguration {
    val builder = DscNodeConfigurationResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [DscNodeConfiguration].
 * @param name The _unique_ name of the resulting resource.
 */
public fun dscNodeConfiguration(name: String): DscNodeConfiguration {
    val builder = DscNodeConfigurationResourceBuilder()
    builder.name(name)
    return builder.build()
}
