@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.automation.kotlin

import com.pulumi.azurenative.automation.DscNodeConfigurationArgs.builder
import com.pulumi.azurenative.automation.kotlin.inputs.ContentSourceArgs
import com.pulumi.azurenative.automation.kotlin.inputs.ContentSourceArgsBuilder
import com.pulumi.azurenative.automation.kotlin.inputs.DscConfigurationAssociationPropertyArgs
import com.pulumi.azurenative.automation.kotlin.inputs.DscConfigurationAssociationPropertyArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Definition of the dsc node configuration.
 * Azure REST API version: 2022-08-08. Prior API version in Azure Native 1.x: 2019-06-01.
 * Other available API versions: 2023-05-15-preview, 2023-11-01.
 * ## Example Usage
 * ### Create node configuration
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var dscNodeConfiguration = new AzureNative.Automation.DscNodeConfiguration("dscNodeConfiguration", new()
 *     {
 *         AutomationAccountName = "myAutomationAccount20",
 *         Configuration = new AzureNative.Automation.Inputs.DscConfigurationAssociationPropertyArgs
 *         {
 *             Name = "configName",
 *         },
 *         IncrementNodeConfigurationBuild = true,
 *         Name = "configName.nodeConfigName",
 *         NodeConfigurationName = "configName.nodeConfigName",
 *         ResourceGroupName = "rg",
 *         Source = new AzureNative.Automation.Inputs.ContentSourceArgs
 *         {
 *             Hash = new AzureNative.Automation.Inputs.ContentHashArgs
 *             {
 *                 Algorithm = "sha256",
 *                 Value = "6DE256A57F01BFA29B88696D5E77A383D6E61484C7686E8DB955FA10ACE9FFE5",
 *             },
 *             Type = "embeddedContent",
 *             Value = @"
 * instance of MSFT_RoleResource as $MSFT_RoleResource1ref
 * {
 * ResourceID = ""[WindowsFeature]IIS"";
 *  Ensure = ""Present"";
 *  SourceInfo = ""::3::32::WindowsFeature"";
 *  Name = ""Web-Server"";
 *  ModuleName = ""PsDesiredStateConfiguration"";
 * ModuleVersion = ""1.0"";
 *  ConfigurationName = ""configName"";
 * };
 * instance of OMI_ConfigurationDocument
 *                     {
 *  Version=""2.0.0"";
 *                         MinimumCompatibleVersion = ""1.0.0"";
 *                         CompatibleVersionAdditionalProperties= {""Omi_BaseResource:ConfigurationName""};
 *                         Author=""weijiel"";
 *                         GenerationDate=""03/30/2017 13:40:25"";
 *                         GenerationHost=""TEST-BACKEND"";
 *                         Name=""configName"";
 *                     };
 * ",
 *             Version = "1.0",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/automation/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := automation.NewDscNodeConfiguration(ctx, "dscNodeConfiguration", &automation.DscNodeConfigurationArgs{
 * 			AutomationAccountName: pulumi.String("myAutomationAccount20"),
 * 			Configuration: &automation.DscConfigurationAssociationPropertyArgs{
 * 				Name: pulumi.String("configName"),
 * 			},
 * 			IncrementNodeConfigurationBuild: pulumi.Bool(true),
 * 			Name:                            pulumi.String("configName.nodeConfigName"),
 * 			NodeConfigurationName:           pulumi.String("configName.nodeConfigName"),
 * 			ResourceGroupName:               pulumi.String("rg"),
 * 			Source: &automation.ContentSourceArgs{
 * 				Hash: &automation.ContentHashArgs{
 * 					Algorithm: pulumi.String("sha256"),
 * 					Value:     pulumi.String("6DE256A57F01BFA29B88696D5E77A383D6E61484C7686E8DB955FA10ACE9FFE5"),
 * 				},
 * 				Type: pulumi.String("embeddedContent"),
 * 				Value: pulumi.String(`
 * instance of MSFT_RoleResource as $MSFT_RoleResource1ref
 * {
 * ResourceID = "[WindowsFeature]IIS";
 *  Ensure = "Present";
 *  SourceInfo = "::3::32::WindowsFeature";
 *  Name = "Web-Server";
 *  ModuleName = "PsDesiredStateConfiguration";
 * ModuleVersion = "1.0";
 *  ConfigurationName = "configName";
 * };
 * instance of OMI_ConfigurationDocument
 *                     {
 *  Version="2.0.0";
 *                         MinimumCompatibleVersion = "1.0.0";
 *                         CompatibleVersionAdditionalProperties= {"Omi_BaseResource:ConfigurationName"};
 *                         Author="weijiel";
 *                         GenerationDate="03/30/2017 13:40:25";
 *                         GenerationHost="TEST-BACKEND";
 *                         Name="configName";
 *                     };
 * `),
 * 				Version: pulumi.String("1.0"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.automation.DscNodeConfiguration;
 * import com.pulumi.azurenative.automation.DscNodeConfigurationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var dscNodeConfiguration = new DscNodeConfiguration("dscNodeConfiguration", DscNodeConfigurationArgs.builder()
 *             .automationAccountName("myAutomationAccount20")
 *             .configuration(Map.of("name", "configName"))
 *             .incrementNodeConfigurationBuild(true)
 *             .name("configName.nodeConfigName")
 *             .nodeConfigurationName("configName.nodeConfigName")
 *             .resourceGroupName("rg")
 *             .source(Map.ofEntries(
 *                 Map.entry("hash", Map.ofEntries(
 *                     Map.entry("algorithm", "sha256"),
 *                     Map.entry("value", "6DE256A57F01BFA29B88696D5E77A383D6E61484C7686E8DB955FA10ACE9FFE5")
 *                 )),
 *                 Map.entry("type", "embeddedContent"),
 *                 Map.entry("value", """
 * instance of MSFT_RoleResource as $MSFT_RoleResource1ref
 * {
 * ResourceID = "[WindowsFeature]IIS";
 *  Ensure = "Present";
 *  SourceInfo = "::3::32::WindowsFeature";
 *  Name = "Web-Server";
 *  ModuleName = "PsDesiredStateConfiguration";
 * ModuleVersion = "1.0";
 *  ConfigurationName = "configName";
 * };
 * instance of OMI_ConfigurationDocument
 *                     {
 *  Version="2.0.0";
 *                         MinimumCompatibleVersion = "1.0.0";
 *                         CompatibleVersionAdditionalProperties= {"Omi_BaseResource:ConfigurationName"};
 *                         Author="weijiel";
 *                         GenerationDate="03/30/2017 13:40:25";
 *                         GenerationHost="TEST-BACKEND";
 *                         Name="configName";
 *                     };
 *                 """),
 *                 Map.entry("version", "1.0")
 *             ))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:automation:DscNodeConfiguration configName.nodeConfigName /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Automation/automationAccounts/{automationAccountName}/nodeConfigurations/{nodeConfigurationName}
 * ```
 * @property automationAccountName The name of the automation account.
 * @property configuration Gets or sets the configuration of the node.
 * @property incrementNodeConfigurationBuild If a new build version of NodeConfiguration is required.
 * @property name Name of the node configuration.
 * @property nodeConfigurationName The Dsc node configuration name.
 * @property resourceGroupName Name of an Azure Resource group.
 * @property source Gets or sets the source.
 * @property tags Gets or sets the tags attached to the resource.
 */
public data class DscNodeConfigurationArgs(
    public val automationAccountName: Output<String>? = null,
    public val configuration: Output<DscConfigurationAssociationPropertyArgs>? = null,
    public val incrementNodeConfigurationBuild: Output<Boolean>? = null,
    public val name: Output<String>? = null,
    public val nodeConfigurationName: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val source: Output<ContentSourceArgs>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.automation.DscNodeConfigurationArgs> {
    override fun toJava(): com.pulumi.azurenative.automation.DscNodeConfigurationArgs =
        com.pulumi.azurenative.automation.DscNodeConfigurationArgs.builder()
            .automationAccountName(automationAccountName?.applyValue({ args0 -> args0 }))
            .configuration(configuration?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .incrementNodeConfigurationBuild(incrementNodeConfigurationBuild?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .nodeConfigurationName(nodeConfigurationName?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .source(source?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [DscNodeConfigurationArgs].
 */
@PulumiTagMarker
public class DscNodeConfigurationArgsBuilder internal constructor() {
    private var automationAccountName: Output<String>? = null

    private var configuration: Output<DscConfigurationAssociationPropertyArgs>? = null

    private var incrementNodeConfigurationBuild: Output<Boolean>? = null

    private var name: Output<String>? = null

    private var nodeConfigurationName: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var source: Output<ContentSourceArgs>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value The name of the automation account.
     */
    @JvmName("debnqkwkkbgtuewd")
    public suspend fun automationAccountName(`value`: Output<String>) {
        this.automationAccountName = value
    }

    /**
     * @param value Gets or sets the configuration of the node.
     */
    @JvmName("lwurftcajdqjegcw")
    public suspend fun configuration(`value`: Output<DscConfigurationAssociationPropertyArgs>) {
        this.configuration = value
    }

    /**
     * @param value If a new build version of NodeConfiguration is required.
     */
    @JvmName("lkfgrswlyvojffsr")
    public suspend fun incrementNodeConfigurationBuild(`value`: Output<Boolean>) {
        this.incrementNodeConfigurationBuild = value
    }

    /**
     * @param value Name of the node configuration.
     */
    @JvmName("rwyprpikstjgvjgg")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The Dsc node configuration name.
     */
    @JvmName("jfhymnxrhollmuxp")
    public suspend fun nodeConfigurationName(`value`: Output<String>) {
        this.nodeConfigurationName = value
    }

    /**
     * @param value Name of an Azure Resource group.
     */
    @JvmName("xggclngphkdgevpj")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Gets or sets the source.
     */
    @JvmName("jtexmyslfqgybxhq")
    public suspend fun source(`value`: Output<ContentSourceArgs>) {
        this.source = value
    }

    /**
     * @param value Gets or sets the tags attached to the resource.
     */
    @JvmName("awxucnpqoqjokbrm")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The name of the automation account.
     */
    @JvmName("fxcwttyuchamgidw")
    public suspend fun automationAccountName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.automationAccountName = mapped
    }

    /**
     * @param value Gets or sets the configuration of the node.
     */
    @JvmName("mwqmrspljnpbdmbg")
    public suspend fun configuration(`value`: DscConfigurationAssociationPropertyArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.configuration = mapped
    }

    /**
     * @param argument Gets or sets the configuration of the node.
     */
    @JvmName("yrbajjqwmbiptqkq")
    public suspend
    fun configuration(argument: suspend DscConfigurationAssociationPropertyArgsBuilder.() -> Unit) {
        val toBeMapped = DscConfigurationAssociationPropertyArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.configuration = mapped
    }

    /**
     * @param value If a new build version of NodeConfiguration is required.
     */
    @JvmName("cmbltijsnukwgygy")
    public suspend fun incrementNodeConfigurationBuild(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.incrementNodeConfigurationBuild = mapped
    }

    /**
     * @param value Name of the node configuration.
     */
    @JvmName("knosvjvhfflvmgqh")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The Dsc node configuration name.
     */
    @JvmName("sxpqycufekkqgksk")
    public suspend fun nodeConfigurationName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.nodeConfigurationName = mapped
    }

    /**
     * @param value Name of an Azure Resource group.
     */
    @JvmName("pjwtlvmaqvpibiak")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Gets or sets the source.
     */
    @JvmName("xsnpwmpsbchclyyu")
    public suspend fun source(`value`: ContentSourceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.source = mapped
    }

    /**
     * @param argument Gets or sets the source.
     */
    @JvmName("ovvdwhuhlcxcjwyc")
    public suspend fun source(argument: suspend ContentSourceArgsBuilder.() -> Unit) {
        val toBeMapped = ContentSourceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.source = mapped
    }

    /**
     * @param value Gets or sets the tags attached to the resource.
     */
    @JvmName("tofwiawuaplrgwmp")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Gets or sets the tags attached to the resource.
     */
    @JvmName("itecbousntkqouqx")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): DscNodeConfigurationArgs = DscNodeConfigurationArgs(
        automationAccountName = automationAccountName,
        configuration = configuration,
        incrementNodeConfigurationBuild = incrementNodeConfigurationBuild,
        name = name,
        nodeConfigurationName = nodeConfigurationName,
        resourceGroupName = resourceGroupName,
        source = source,
        tags = tags,
    )
}
