@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.automation.kotlin

import com.pulumi.azurenative.automation.HybridRunbookWorkerArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Definition of hybrid runbook worker.
 * Azure REST API version: 2022-08-08. Prior API version in Azure Native 1.x: 2021-06-22.
 * Other available API versions: 2023-05-15-preview, 2023-11-01.
 * ## Example Usage
 * ### Create a V2 hybrid runbook worker
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var hybridRunbookWorker = new AzureNative.Automation.HybridRunbookWorker("hybridRunbookWorker", new()
 *     {
 *         AutomationAccountName = "testaccount",
 *         HybridRunbookWorkerGroupName = "TestHybridGroup",
 *         HybridRunbookWorkerId = "c010ad12-ef14-4a2a-aa9e-ef22c4745ddd",
 *         ResourceGroupName = "rg",
 *         VmResourceId = "/subscriptions/vmsubid/resourceGroups/vmrg/providers/Microsoft.Compute/virtualMachines/vmname",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/automation/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := automation.NewHybridRunbookWorker(ctx, "hybridRunbookWorker", &automation.HybridRunbookWorkerArgs{
 * 			AutomationAccountName:        pulumi.String("testaccount"),
 * 			HybridRunbookWorkerGroupName: pulumi.String("TestHybridGroup"),
 * 			HybridRunbookWorkerId:        pulumi.String("c010ad12-ef14-4a2a-aa9e-ef22c4745ddd"),
 * 			ResourceGroupName:            pulumi.String("rg"),
 * 			VmResourceId:                 pulumi.String("/subscriptions/vmsubid/resourceGroups/vmrg/providers/Microsoft.Compute/virtualMachines/vmname"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.automation.HybridRunbookWorker;
 * import com.pulumi.azurenative.automation.HybridRunbookWorkerArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var hybridRunbookWorker = new HybridRunbookWorker("hybridRunbookWorker", HybridRunbookWorkerArgs.builder()
 *             .automationAccountName("testaccount")
 *             .hybridRunbookWorkerGroupName("TestHybridGroup")
 *             .hybridRunbookWorkerId("c010ad12-ef14-4a2a-aa9e-ef22c4745ddd")
 *             .resourceGroupName("rg")
 *             .vmResourceId("/subscriptions/vmsubid/resourceGroups/vmrg/providers/Microsoft.Compute/virtualMachines/vmname")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:automation:HybridRunbookWorker c010ad12-ef14-4a2a-aa9e-ef22c4745ddd /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Automation/automationAccounts/{automationAccountName}/hybridRunbookWorkerGroups/{hybridRunbookWorkerGroupName}/hybridRunbookWorkers/{hybridRunbookWorkerId}
 * ```
 * @property automationAccountName The name of the automation account.
 * @property hybridRunbookWorkerGroupName The hybrid runbook worker group name
 * @property hybridRunbookWorkerId The hybrid runbook worker id
 * @property name Gets or sets the name of the resource.
 * @property resourceGroupName Name of an Azure Resource group.
 * @property vmResourceId Azure Resource Manager Id for a virtual machine.
 */
public data class HybridRunbookWorkerArgs(
    public val automationAccountName: Output<String>? = null,
    public val hybridRunbookWorkerGroupName: Output<String>? = null,
    public val hybridRunbookWorkerId: Output<String>? = null,
    public val name: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val vmResourceId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.automation.HybridRunbookWorkerArgs> {
    override fun toJava(): com.pulumi.azurenative.automation.HybridRunbookWorkerArgs =
        com.pulumi.azurenative.automation.HybridRunbookWorkerArgs.builder()
            .automationAccountName(automationAccountName?.applyValue({ args0 -> args0 }))
            .hybridRunbookWorkerGroupName(hybridRunbookWorkerGroupName?.applyValue({ args0 -> args0 }))
            .hybridRunbookWorkerId(hybridRunbookWorkerId?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .vmResourceId(vmResourceId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [HybridRunbookWorkerArgs].
 */
@PulumiTagMarker
public class HybridRunbookWorkerArgsBuilder internal constructor() {
    private var automationAccountName: Output<String>? = null

    private var hybridRunbookWorkerGroupName: Output<String>? = null

    private var hybridRunbookWorkerId: Output<String>? = null

    private var name: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var vmResourceId: Output<String>? = null

    /**
     * @param value The name of the automation account.
     */
    @JvmName("rlvjvpqxgyiwbevm")
    public suspend fun automationAccountName(`value`: Output<String>) {
        this.automationAccountName = value
    }

    /**
     * @param value The hybrid runbook worker group name
     */
    @JvmName("ffvkxqemeejxwkth")
    public suspend fun hybridRunbookWorkerGroupName(`value`: Output<String>) {
        this.hybridRunbookWorkerGroupName = value
    }

    /**
     * @param value The hybrid runbook worker id
     */
    @JvmName("xinrxdvyibgkbctx")
    public suspend fun hybridRunbookWorkerId(`value`: Output<String>) {
        this.hybridRunbookWorkerId = value
    }

    /**
     * @param value Gets or sets the name of the resource.
     */
    @JvmName("cavkmoibirlepdht")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Name of an Azure Resource group.
     */
    @JvmName("cmrmjbeojmscovhw")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Azure Resource Manager Id for a virtual machine.
     */
    @JvmName("nvktubkvewcgaxns")
    public suspend fun vmResourceId(`value`: Output<String>) {
        this.vmResourceId = value
    }

    /**
     * @param value The name of the automation account.
     */
    @JvmName("onechjmlislgwqge")
    public suspend fun automationAccountName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.automationAccountName = mapped
    }

    /**
     * @param value The hybrid runbook worker group name
     */
    @JvmName("oiopjcbabfbhxvjk")
    public suspend fun hybridRunbookWorkerGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.hybridRunbookWorkerGroupName = mapped
    }

    /**
     * @param value The hybrid runbook worker id
     */
    @JvmName("wymehbeotfvsrbmi")
    public suspend fun hybridRunbookWorkerId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.hybridRunbookWorkerId = mapped
    }

    /**
     * @param value Gets or sets the name of the resource.
     */
    @JvmName("gomyuvtwtgiqmmyc")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Name of an Azure Resource group.
     */
    @JvmName("tjqagpsrgnndppiy")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Azure Resource Manager Id for a virtual machine.
     */
    @JvmName("dlvicspnudarqtes")
    public suspend fun vmResourceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vmResourceId = mapped
    }

    internal fun build(): HybridRunbookWorkerArgs = HybridRunbookWorkerArgs(
        automationAccountName = automationAccountName,
        hybridRunbookWorkerGroupName = hybridRunbookWorkerGroupName,
        hybridRunbookWorkerId = hybridRunbookWorkerId,
        name = name,
        resourceGroupName = resourceGroupName,
        vmResourceId = vmResourceId,
    )
}
