@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.automation.kotlin

import com.pulumi.azurenative.automation.PackageArgs.builder
import com.pulumi.azurenative.automation.kotlin.inputs.ContentLinkArgs
import com.pulumi.azurenative.automation.kotlin.inputs.ContentLinkArgsBuilder
import com.pulumi.azurenative.automation.kotlin.inputs.TrackedResourceArgs
import com.pulumi.azurenative.automation.kotlin.inputs.TrackedResourceArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Definition of the Package type.
 * Azure REST API version: 2023-05-15-preview.
 * ## Example Usage
 * ### Create or update a package
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var package = new AzureNative.Automation.Package("package", new()
 *     {
 *         AutomationAccountName = "myAutomationAccount33",
 *         ContentLink = new AzureNative.Automation.Inputs.ContentLinkArgs
 *         {
 *             ContentHash = new AzureNative.Automation.Inputs.ContentHashArgs
 *             {
 *                 Algorithm = "sha265",
 *                 Value = "07E108A962B81DD9C9BAA89BB47C0F6EE52B29E83758B07795E408D258B2B87A",
 *             },
 *             Uri = "https://teststorage.blob.core.windows.net/dsccomposite/OmsCompositeResources.zip",
 *         },
 *         PackageName = "OmsCompositeResources",
 *         ResourceGroupName = "rg",
 *         RuntimeEnvironmentName = "runtimeEnvironmentName",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/automation/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := automation.NewPackage(ctx, "package", &automation.PackageArgs{
 * 			AutomationAccountName: pulumi.String("myAutomationAccount33"),
 * 			ContentLink: automation.ContentLinkResponse{
 * 				ContentHash: &automation.ContentHashArgs{
 * 					Algorithm: pulumi.String("sha265"),
 * 					Value:     pulumi.String("07E108A962B81DD9C9BAA89BB47C0F6EE52B29E83758B07795E408D258B2B87A"),
 * 				},
 * 				Uri: pulumi.String("https://teststorage.blob.core.windows.net/dsccomposite/OmsCompositeResources.zip"),
 * 			},
 * 			PackageName:            pulumi.String("OmsCompositeResources"),
 * 			ResourceGroupName:      pulumi.String("rg"),
 * 			RuntimeEnvironmentName: pulumi.String("runtimeEnvironmentName"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.automation.Package;
 * import com.pulumi.azurenative.automation.PackageArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var package_ = new Package("package", PackageArgs.builder()
 *             .automationAccountName("myAutomationAccount33")
 *             .contentLink(Map.ofEntries(
 *                 Map.entry("contentHash", Map.ofEntries(
 *                     Map.entry("algorithm", "sha265"),
 *                     Map.entry("value", "07E108A962B81DD9C9BAA89BB47C0F6EE52B29E83758B07795E408D258B2B87A")
 *                 )),
 *                 Map.entry("uri", "https://teststorage.blob.core.windows.net/dsccomposite/OmsCompositeResources.zip")
 *             ))
 *             .packageName("OmsCompositeResources")
 *             .resourceGroupName("rg")
 *             .runtimeEnvironmentName("runtimeEnvironmentName")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:automation:Package OmsCompositeResources /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Automation/automationAccounts/{automationAccountName}/runtimeEnvironments/{runtimeEnvironmentName}/packages/{packageName}
 * ```
 * @property allOf The resource model definition for an Azure Resource Manager tracked top level resource which has 'tags' and a 'location'
 * @property automationAccountName The name of the automation account.
 * @property contentLink Gets or sets the package content link.
 * @property packageName The name of Package.
 * @property resourceGroupName Name of an Azure Resource group.
 * @property runtimeEnvironmentName The name of the Runtime Environment.
 */
public data class PackageArgs(
    public val allOf: Output<TrackedResourceArgs>? = null,
    public val automationAccountName: Output<String>? = null,
    public val contentLink: Output<ContentLinkArgs>? = null,
    public val packageName: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val runtimeEnvironmentName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.automation.PackageArgs> {
    override fun toJava(): com.pulumi.azurenative.automation.PackageArgs =
        com.pulumi.azurenative.automation.PackageArgs.builder()
            .allOf(allOf?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .automationAccountName(automationAccountName?.applyValue({ args0 -> args0 }))
            .contentLink(contentLink?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .packageName(packageName?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .runtimeEnvironmentName(runtimeEnvironmentName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [PackageArgs].
 */
@PulumiTagMarker
public class PackageArgsBuilder internal constructor() {
    private var allOf: Output<TrackedResourceArgs>? = null

    private var automationAccountName: Output<String>? = null

    private var contentLink: Output<ContentLinkArgs>? = null

    private var packageName: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var runtimeEnvironmentName: Output<String>? = null

    /**
     * @param value The resource model definition for an Azure Resource Manager tracked top level resource which has 'tags' and a 'location'
     */
    @JvmName("eagfmgjvwdbboxlr")
    public suspend fun allOf(`value`: Output<TrackedResourceArgs>) {
        this.allOf = value
    }

    /**
     * @param value The name of the automation account.
     */
    @JvmName("weqenbsvesbhrbvh")
    public suspend fun automationAccountName(`value`: Output<String>) {
        this.automationAccountName = value
    }

    /**
     * @param value Gets or sets the package content link.
     */
    @JvmName("vvwwmwtgchiemxhv")
    public suspend fun contentLink(`value`: Output<ContentLinkArgs>) {
        this.contentLink = value
    }

    /**
     * @param value The name of Package.
     */
    @JvmName("ujjfbkkespsagrvn")
    public suspend fun packageName(`value`: Output<String>) {
        this.packageName = value
    }

    /**
     * @param value Name of an Azure Resource group.
     */
    @JvmName("cbcaedxkayeyctqw")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The name of the Runtime Environment.
     */
    @JvmName("ltqsqvxpwxhkayop")
    public suspend fun runtimeEnvironmentName(`value`: Output<String>) {
        this.runtimeEnvironmentName = value
    }

    /**
     * @param value The resource model definition for an Azure Resource Manager tracked top level resource which has 'tags' and a 'location'
     */
    @JvmName("sfewyadybtgyxdyp")
    public suspend fun allOf(`value`: TrackedResourceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.allOf = mapped
    }

    /**
     * @param argument The resource model definition for an Azure Resource Manager tracked top level resource which has 'tags' and a 'location'
     */
    @JvmName("nbhilvpfknbfsxwb")
    public suspend fun allOf(argument: suspend TrackedResourceArgsBuilder.() -> Unit) {
        val toBeMapped = TrackedResourceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.allOf = mapped
    }

    /**
     * @param value The name of the automation account.
     */
    @JvmName("kvbioadlsmqfcdxg")
    public suspend fun automationAccountName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.automationAccountName = mapped
    }

    /**
     * @param value Gets or sets the package content link.
     */
    @JvmName("njpdanyxdaejfmbx")
    public suspend fun contentLink(`value`: ContentLinkArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.contentLink = mapped
    }

    /**
     * @param argument Gets or sets the package content link.
     */
    @JvmName("hgarmfpermfbxwlk")
    public suspend fun contentLink(argument: suspend ContentLinkArgsBuilder.() -> Unit) {
        val toBeMapped = ContentLinkArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.contentLink = mapped
    }

    /**
     * @param value The name of Package.
     */
    @JvmName("xgxqwrdaobqlshxr")
    public suspend fun packageName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.packageName = mapped
    }

    /**
     * @param value Name of an Azure Resource group.
     */
    @JvmName("akpdwkipwanqhrkp")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the Runtime Environment.
     */
    @JvmName("elhhxscoxvuwllcw")
    public suspend fun runtimeEnvironmentName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.runtimeEnvironmentName = mapped
    }

    internal fun build(): PackageArgs = PackageArgs(
        allOf = allOf,
        automationAccountName = automationAccountName,
        contentLink = contentLink,
        packageName = packageName,
        resourceGroupName = resourceGroupName,
        runtimeEnvironmentName = runtimeEnvironmentName,
    )
}
